/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.data.advancement;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.CeiTriggers;

public class AccumulativeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    final ResourceLocation id;

    public AccumulativeTrigger(ResourceLocation pId) {
        this.id = pId;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject pJson, @NotNull EntityPredicate.Composite pPlayer, @NotNull DeserializationContext pContext) {
        MinMaxBounds.Ints requirements = MinMaxBounds.Ints.m_55373_((JsonElement)pJson.get("requirement"));
        return new TriggerInstance(this.id, pPlayer, requirements);
    }

    public void trigger(Player pPlayer, int change) {
        this.m_66234_((ServerPlayer)pPlayer, triggerInstance -> triggerInstance.matches(this.id, pPlayer, change));
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.id;
    }

    private static AccumulativeData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world.");
        }
        ServerLevel serverWorld = level.m_142572_().m_129783_();
        DimensionDataStorage dimensionSavedDataManager = serverWorld.m_8895_();
        return (AccumulativeData)dimensionSavedDataManager.m_164861_(AccumulativeData::load, AccumulativeData::new, "accumulative_data");
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints requirement;

        public static TriggerInstance ofBook(int requirement) {
            return new TriggerInstance(CeiTriggers.BOOK_PRINTED.id, EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.m_55386_((int)requirement));
        }

        public static TriggerInstance ofExperienceDisenchanted(int requirement) {
            return new TriggerInstance(CeiTriggers.DISENCHANTED.id, EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.m_55386_((int)requirement));
        }

        public TriggerInstance(ResourceLocation pCriterion, EntityPredicate.Composite pPlayer, MinMaxBounds.Ints requirement) {
            super(pCriterion, pPlayer);
            this.requirement = requirement;
        }

        public boolean matches(ResourceLocation resourceLocation, Player player, int change) {
            AccumulativeData data = AccumulativeTrigger.get(player.f_19853_);
            data.change(resourceLocation, player.m_142081_(), change);
            return this.requirement.m_55390_(data.get(resourceLocation, player.m_142081_()));
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext pConditions) {
            JsonObject jsonobject = super.m_7683_(pConditions);
            jsonobject.add("requirement", this.requirement.m_55328_());
            return jsonobject;
        }
    }

    private static class AccumulativeData
    extends SavedData {
        public Table<ResourceLocation, UUID, Integer> data = HashBasedTable.create();

        public void change(ResourceLocation resourceLocation, UUID playerId, int i) {
            Integer temp = (Integer)this.data.get((Object)resourceLocation, (Object)playerId);
            temp = temp == null ? 0 : temp;
            temp = temp + i;
            this.data.put((Object)resourceLocation, (Object)playerId, (Object)temp);
            this.m_77762_();
        }

        public int get(ResourceLocation resourceLocation, UUID playerId) {
            Integer ret = (Integer)this.data.get((Object)resourceLocation, (Object)playerId);
            return ret == null ? 0 : ret;
        }

        public static AccumulativeData load(CompoundTag compoundNBT) {
            AccumulativeData ret = new AccumulativeData();
            if (!compoundNBT.m_128441_("AccumulativeData")) {
                return ret;
            }
            List list = NBTHelper.readCompoundList((ListTag)((ListTag)compoundNBT.m_128423_("AccumulativeData")), c -> new TriCell(NBTHelper.readResourceLocation((CompoundTag)c, (String)"TriggerId"), c.m_128342_("PlayerId"), c.m_128451_("Count")));
            list.forEach(triCell -> ret.data.put((Object)triCell.rl, (Object)triCell.id, (Object)triCell.i));
            return ret;
        }

        public CompoundTag m_7176_(CompoundTag pCompoundTag) {
            ListTag dataListTag = NBTHelper.writeCompoundList(this.data.cellSet().stream().toList(), cell -> {
                CompoundTag ret = new CompoundTag();
                NBTHelper.writeResourceLocation((CompoundTag)ret, (String)"TriggerId", (ResourceLocation)((ResourceLocation)cell.getRowKey()));
                ret.m_128362_("PlayerId", (UUID)cell.getColumnKey());
                ret.m_128405_("Count", ((Integer)cell.getValue()).intValue());
                return ret;
            });
            pCompoundTag.m_128365_("AccumulativeData", (Tag)dataListTag);
            return pCompoundTag;
        }

        private record TriCell(ResourceLocation rl, UUID id, int i) {
        }
    }
}

