/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.data.advancement;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import plus.dragons.createenchantmentindustry.entry.CeiBlocks;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiItems;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.AccumulativeTrigger;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.CeiAdvancement;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CeiAdvancements
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final List<CeiAdvancement> ENTRIES = new ArrayList<CeiAdvancement>();
    public static final CeiAdvancement START = null;
    public static final CeiAdvancement EXPERIENCED_ENGINEER = CeiAdvancements.builder("experienced_engineer").title("Experienced Engineer").description("Get some Nuggets of Experience from crushing ores or killing mobs using deployer").icon((ItemProviderEntry<?>)AllItems.EXP_NUGGET).externalTrigger("have_experience_nugget", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AllItems.EXP_NUGGET.get()})).parent(Create.asResource((String)"display_board_0")).build();
    public static final CeiAdvancement BLACK_AS_INK = CeiAdvancements.builder("black_as_ink").title("Black as Ink!").description("Get a bucket of Ink for your publishing business").icon((ItemLike)((ForgeFlowingFluid.Flowing)CeiFluids.INK.get()).m_6859_()).externalTrigger("have_bucket_of_ink", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{((ForgeFlowingFluid.Flowing)CeiFluids.INK.get()).m_6859_()})).parent(EXPERIENCED_ENGINEER).build();
    public static final CeiAdvancement COPIABLE_MASTERPIECE = CeiAdvancements.builder("copiable_masterpiece").title("Copiable Masterpiece").description("Copy a Written Book using Printer").icon((ItemLike)Items.f_42615_).parent(BLACK_AS_INK).build();
    public static final CeiAdvancement COPIABLE_MYSTERY = CeiAdvancements.builder("copiable_mystery").title("Copiable Mystery").description("Copy a Enchanted Book using Printer").icon((ItemLike)Items.f_42690_).announce(true).parent(COPIABLE_MASTERPIECE).build();
    public static final CeiAdvancement RELIC_RESTORATION = CeiAdvancements.builder("relic_restoration").title("Relic Restoration").description("Make brand new copy from a tattered book").icon((ItemLike)Items.f_42614_).announce(true).frame(FrameType.GOAL).parent(COPIABLE_MYSTERY).build();
    public static final CeiAdvancement EMERGING_BRAND = CeiAdvancements.builder("emerging_brand").title("Emerging Brand").description("Using the printer to name items").icon((ItemLike)Items.f_42656_).announce(true).parent(COPIABLE_MASTERPIECE).build();
    public static final CeiAdvancement GREAT_PUBLISHER = CeiAdvancements.builder("great_publisher").title("Great Publisher").description("Copy 1000 books using Printer").externalTrigger("book_copied", (CriterionTriggerInstance)AccumulativeTrigger.TriggerInstance.ofBook(1000)).icon((ItemProviderEntry<?>)CeiBlocks.PRINTER).announce(true).frame(FrameType.CHALLENGE).parent(RELIC_RESTORATION).build();
    public static final CeiAdvancement EXPERIMENTAL = CeiAdvancements.builder("experimental").title("Experimental").description("Get some Liquid Experience for your enchanting experiment!").icon((ItemLike)Items.f_42612_).parent(EXPERIENCED_ENGINEER).build();
    public static final CeiAdvancement GONE_WITH_THE_FOIL = CeiAdvancements.builder("gone_with_the_foil").title("Gone with the Foil").description("Watch an enchanted item be disenchanted by a Disenchanter").icon((ItemProviderEntry<?>)CeiBlocks.DISENCHANTER).parent(EXPERIMENTAL).build();
    public static final CeiAdvancement SPIRIT_TAKING = CeiAdvancements.builder("spirit_taking").title("Spirit Taking").description("Get your experience absorbed by a Disenchanter").icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_PUMP).announce(true).parent(GONE_WITH_THE_FOIL).build();
    public static final CeiAdvancement A_SHOWER_EXPERIENCE = CeiAdvancements.builder("a_shower_experience").title("A Shower \"Experience\"").description("Break a Fluid Pipe and bathe in the leaked experience").icon((ItemProviderEntry<?>)AllBlocks.FLUID_PIPE).announce(true).frame(FrameType.GOAL).parent(SPIRIT_TAKING).build();
    public static final CeiAdvancement EXPERIENCED_RECYCLER = CeiAdvancements.builder("experienced_recycler").title("Experienced Recycler").description("Recycle 1,000,000 mB of experience from Disenchanter").icon((ItemProviderEntry<?>)AllBlocks.COPPER_VALVE_HANDLE).externalTrigger("experience_recycled", (CriterionTriggerInstance)AccumulativeTrigger.TriggerInstance.ofExperienceDisenchanted(1000000)).announce(true).frame(FrameType.CHALLENGE).parent(A_SHOWER_EXPERIENCE).build();
    public static final CeiAdvancement BLAZES_NEW_JOB = CeiAdvancements.builder("blazes_new_job").title("Blaze's New Job").description("Give your Blaze Burner a Enchanting Guide and turn it into a Blaze Enchanter").icon((ItemProviderEntry<?>)CeiItems.ENCHANTING_GUIDE).parent(EXPERIENCED_ENGINEER).build();
    public static final CeiAdvancement FIRST_ORDER = CeiAdvancements.builder("first_order").title("First Order").description("Add a new enchantment to an unenchanted item using Blaze Enchanter").icon((ItemLike)Items.f_42476_).parent(BLAZES_NEW_JOB).build();
    public static final CeiAdvancement ADDITIONAL_ORDER = CeiAdvancements.builder("additional_order").title("Additional Order").description("Add a new enchantment to an enchanted item using Blaze Enchanter").icon((ItemStack)Util.m_137469_((Object)new ItemStack((ItemLike)Items.f_42476_), stack -> EnchantmentHelper.m_44865_(Map.of(Enchantments.f_44965_, 5), (ItemStack)stack))).parent(FIRST_ORDER).build();
    public static final CeiAdvancement HYPOTHETICAL_EXTENSION = CeiAdvancements.builder("hypothetical_extension").title("Hypothetical Extension").description("Add a new enchantment to an item using Blaze Enchanter's hyper-enchanting").icon((ItemLike)Items.f_42472_).parent(ADDITIONAL_ORDER).build();
    public static final CeiAdvancement END = null;
    private final DataGenerator generator;

    public static CeiAdvancement.Builder builder(String id) {
        return new CeiAdvancement.Builder(id);
    }

    public CeiAdvancements(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path advancementPath = path.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)advancementPath);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)advancementPath, (Object)ioexception);
            }
        };
        for (CeiAdvancement advancement2 : ENTRIES) {
            advancement2.save(consumer);
        }
    }

    public String m_6055_() {
        return "Create: Enchantment Industry Advancements";
    }

    public static JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (CeiAdvancement advancement : ENTRIES) {
            advancement.appendToLang(object);
        }
        return object;
    }

    public static void register() {
    }
}

