/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.gui;

import com.google.common.collect.AbstractIterator;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentLabel
extends Label {
    public ComponentLabel(int x, int y, Component text) {
        super(x, y, text);
    }

    private Iterator<Component> getComponentIterator(final Component root) {
        return new AbstractIterator<Component>(){
            private final Deque<Component> stack;
            {
                this.stack = new LinkedList<Component>(Collections.singleton(root));
            }

            @Nullable
            protected Component computeNext() {
                if (this.stack.isEmpty()) {
                    return (Component)this.endOfData();
                }
                Component ret = this.stack.pop();
                ArrayList siblings = new ArrayList(ret.m_7360_());
                Collections.reverse(siblings);
                for (Component c : siblings) {
                    this.stack.push(c);
                }
                return ret;
            }
        };
    }

    private MutableComponent computeTrimmedText(Component text, boolean trimFront, int maxWidthPx) {
        MutableComponent trim;
        maxWidthPx -= this.font.m_92895_("...");
        int totalWidthPx = 0;
        Iterator<Component> texts = this.getComponentIterator(text);
        ArrayList<Object> result = new ArrayList<Object>();
        block0: while (texts.hasNext()) {
            int step;
            int endIndex;
            Component component = texts.next();
            String content = component.m_6111_();
            int widthPx = this.font.m_92852_((FormattedText)Components.literal((String)content).m_6270_(text.m_7383_()));
            if (totalWidthPx < maxWidthPx) {
                result.add(component);
                totalWidthPx += widthPx;
                continue;
            }
            int stringLength = content.length();
            if (stringLength == 0) continue;
            int startIndex = trimFront ? 0 : stringLength - 1;
            int n = endIndex = !trimFront ? 0 : stringLength - 1;
            if (startIndex > endIndex) {
                step = -1;
            } else if (startIndex < endIndex) {
                step = 1;
            } else {
                result.add(Components.literal((String)content).m_6270_(component.m_7383_()));
                break;
            }
            StringBuilder builder = new StringBuilder(content);
            for (int i = startIndex; i != endIndex; i += step) {
                String sub = builder.substring(trimFront ? i : startIndex, trimFront ? endIndex + 1 : i + 1);
                if (this.font.m_92852_((FormattedText)Components.literal((String)sub).m_6270_(text.m_7383_())) > maxWidthPx) continue;
                result.add(Components.literal((String)sub).m_6270_(text.m_7383_()));
                break block0;
            }
        }
        if (trimFront) {
            trim = Components.literal((String)"...").m_6270_(((Component)result.get(0)).m_7383_());
            result.forEach(arg_0 -> ((MutableComponent)trim).m_7220_(arg_0));
            return trim;
        }
        trim = Components.literal((String)"...").m_6270_(((Component)result.get(result.size() - 1)).m_7383_());
        MutableComponent ret = Components.literal((String)"");
        result.forEach(arg_0 -> ((MutableComponent)ret).m_7220_(arg_0));
        return ret.m_7220_((Component)trim);
    }

    public void setTextAndTrim(Component newText, boolean trimFront, int maxWidthPx) {
        if (this.suffix != null) {
            maxWidthPx -= this.font.m_92895_(this.suffix);
        }
        this.text = this.font.m_92852_((FormattedText)newText) <= maxWidthPx ? newText : this.computeTrimmedText(newText, trimFront, maxWidthPx);
    }

    public void m_6303_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Component textToRender;
        if (this.text == null) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Object object = textToRender = this.suffix == null ? this.text : this.text.m_6881_().m_130946_(this.suffix);
        if (this.hasShadow) {
            this.font.m_92763_(matrixStack, textToRender, (float)this.f_93620_, (float)this.f_93621_, this.color);
        } else {
            this.font.m_92889_(matrixStack, textToRender, (float)this.f_93620_, (float)this.f_93621_, this.color);
        }
    }
}

