/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Chimney
extends Container
implements ITiledBlock<Container.Tile> {
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> SIDES = (Map)PipeBlock.f_55154_.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    public static final float WALL_THICKNESS = 0.125f;
    protected final Map<BlockState, VoxelShape> shapesCache;

    public Chimney(Container.Properties<?> props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)Part.PIPE))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true)));
        this.shapesCache = this.m_152458_(this::calculateShapeFor);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, PART, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = super.m_5573_(context);
        state = this.isPlaceForPipe((LevelReader)level, pos) ? (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.PIPE)) : (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.TOP));
        for (Direction direction : GameWorld.Directions.of().horizontals().toList()) {
            boolean connected = GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos.m_142300_(direction));
            state = (BlockState)state.m_61124_((Property)SIDES.get(direction), (Comparable)Boolean.valueOf(!connected));
        }
        return state;
    }

    protected VoxelShape calculateShapeFor(BlockState state) {
        return SIDES.entrySet().stream().filter(entry -> state.m_61138_((Property)entry.getValue())).filter(entry -> (Boolean)state.m_61143_((Property)entry.getValue())).map(Map.Entry::getKey).map(this::makeSideShape).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    protected VoxelShape makeSideShape(Direction side) {
        return switch (side) {
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
            case Direction.EAST -> Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            default -> Shapes.m_83040_();
        };
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        state = this.isPlaceForPipe((LevelReader)worldIn, currentPos) ? (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.PIPE)) : (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.TOP));
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            boolean connected = GameWorld.SmokeContainers.isChimney((LevelReader)worldIn, (BlockPos)facingPos);
            state = (BlockState)state.m_61124_((Property)SIDES.get(facing), (Comparable)Boolean.valueOf(!connected));
        }
        return state;
    }

    protected boolean isPlaceForPipe(LevelReader level, BlockPos placePos) {
        if (GameWorld.SmokeContainers.isVentOrPumpOrChimney((LevelReader)level, (BlockPos)placePos.m_7494_())) {
            return true;
        }
        for (Direction direction : GameWorld.Directions.of().horizontals().toList()) {
            BlockPos pos = placePos.m_142300_(direction);
            if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos) || GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos)) continue;
            BlockState state = level.m_8055_(pos);
            if (state.m_60767_().m_76334_()) {
                return true;
            }
            if (state.m_60783_((BlockGetter)level, pos, direction.m_122424_())) {
                return true;
            }
            if (!state.m_60783_((BlockGetter)level, pos, Direction.UP)) continue;
            return true;
        }
        return false;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return switch (pRot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)));
            default -> pState;
        };
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)pState.m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            default -> super.m_6943_(pState, pMirror);
        };
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue() && ((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            return true;
        }
        return (Boolean)state.m_61143_((Property)WEST) != false && (Boolean)state.m_61143_((Property)EAST) != false;
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(true) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        int opacity;
        int n = opacity = this.isOpaqueMaterial(state) ? 1 : 0;
        if (!this.m_7420_(state, worldIn, pos)) {
            ++opacity;
        }
        return opacity;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.CHIMNEY;
    }

    public boolean isActive(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_61138_((Property)WATERLOGGED) && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public Container.Tile createTile(BlockPos pos, BlockState state) {
        return new Container.Tile(pos, state);
    }

    public Class<Container.Tile> getTileClass() {
        return Container.Tile.class;
    }

    public static enum Part implements IForgeEnum
    {
        TOP,
        PIPE;

    }
}

