/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;

public class LaserBlockBlockEntity
extends LinkableBlockEntity {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.setLasersAccordingToDisabledOption();
        }
    };
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private EnumMap<Direction, Boolean> sideConfig = (EnumMap)Util.m_137537_(() -> {
        EnumMap<Direction, Boolean> map = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            map.put(dir, true);
        }
        return map;
    });

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("sideConfig", (Tag)LaserBlockBlockEntity.saveSideConfig(this.sideConfig));
    }

    public static CompoundTag saveSideConfig(EnumMap<Direction, Boolean> sideConfig) {
        CompoundTag sideConfigTag = new CompoundTag();
        sideConfig.forEach((dir, enabled) -> sideConfigTag.m_128379_(dir.m_122433_(), enabled.booleanValue()));
        return sideConfigTag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.sideConfig = LaserBlockBlockEntity.loadSideConfig(tag.m_128469_("sideConfig"));
    }

    public static EnumMap<Direction, Boolean> loadSideConfig(CompoundTag sideConfigTag) {
        EnumMap<Direction, Boolean> sideConfig = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            if (sideConfigTag.m_128425_(dir.m_122433_(), 1)) {
                sideConfig.put(dir, sideConfigTag.m_128471_(dir.m_122433_()));
                continue;
            }
            sideConfig.put(dir, true);
        }
        return sideConfig;
    }

    @Override
    protected void onLinkedBlockAction(ILinkedAction action, ArrayList<LinkableBlockEntity> excludedBEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            ILinkedAction.OptionChanged optionChanged = (ILinkedAction.OptionChanged)action;
            Option option = optionChanged.option();
            if (option.getName().equals("disabled")) {
                this.disabled.copy(option);
                this.setLasersAccordingToDisabledOption();
            } else if (option.getName().equals("ignoreOwner")) {
                this.ignoreOwner.copy(option);
            }
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            this.insertModule(moduleInserted.stack(), moduleInserted.wasModuleToggled());
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            this.removeModule(moduleRemoved.moduleType(), moduleRemoved.wasModuleToggled());
        } else if (action instanceof ILinkedAction.OwnerChanged) {
            ILinkedAction.OwnerChanged ownerChanged = (ILinkedAction.OwnerChanged)action;
            Owner owner = ownerChanged.newOwner();
            this.setOwner(owner.getUUID(), owner.getName());
        } else if (action instanceof ILinkedAction.StateChanged) {
            ILinkedAction.StateChanged stateChanged = (ILinkedAction.StateChanged)action;
            BlockState state = this.m_58900_();
            if (stateChanged.property() == LaserBlock.POWERED && !((Boolean)state.m_61143_((Property)LaserBlock.POWERED)).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.LASER_BLOCK.get());
                this.f_58857_.m_186460_(this.f_58858_, (Block)SCContent.LASER_BLOCK.get(), 50);
            }
        }
        excludedBEs.add(this);
        this.createLinkedBlockAction(action, excludedBEs);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted(this, stack, toggled);
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved(this, stack, toggled);
        } else if (module == ModuleType.REDSTONE) {
            if (((Boolean)this.m_58900_().m_61143_((Property)LaserBlock.POWERED)).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.LASER_BLOCK.get());
            }
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    @Override
    public void readOptions(CompoundTag tag) {
        if (tag.m_128441_("enabled")) {
            tag.m_128379_("disabled", !tag.m_128471_("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        DisguisableBlockEntity.onSetRemoved(this);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner};
    }

    public IModelData getModelData() {
        return DisguisableBlockEntity.DEFAULT_MODEL_DATA.get();
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public void applyNewSideConfig(EnumMap<Direction, Boolean> sideConfig, Player player) {
        sideConfig.forEach((direction, enabled) -> this.setSideEnabled((Direction)direction, (boolean)enabled, player));
    }

    public void applyExistingSideConfig() {
        for (Direction direction : Direction.values()) {
            this.toggleLaserOnSide(direction, this.isSideEnabled(direction), null, false);
        }
    }

    public void setSideEnabled(Direction direction, boolean enabled, Player player) {
        this.sideConfig.put(direction, enabled);
        if (this.isModuleEnabled(ModuleType.SMART)) {
            this.toggleLaserOnSide(direction, enabled, player, true);
        }
    }

    public void toggleLaserOnSide(Direction direction, boolean enabled, Player player, boolean modifyOtherLaser) {
        BlockEntity blockEntity;
        int i = 1;
        BlockPos pos = this.m_58899_();
        BlockPos modifiedPos = pos.m_5484_(direction, i);
        BlockState stateAtModifiedPos = this.f_58857_.m_8055_(modifiedPos);
        while (i < (Integer)ConfigHandler.SERVER.laserBlockRange.get() && stateAtModifiedPos.m_60734_() != SCContent.LASER_BLOCK.get()) {
            modifiedPos = pos.m_5484_(direction, ++i);
            stateAtModifiedPos = this.f_58857_.m_8055_(modifiedPos);
        }
        if (modifyOtherLaser && (blockEntity = this.f_58857_.m_7702_(modifiedPos)) instanceof LaserBlockBlockEntity) {
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)blockEntity;
            otherLaser.sideConfig.put(direction.m_122424_(), enabled);
        }
        if (enabled && (blockEntity = this.m_58900_().m_60734_()) instanceof LaserBlock) {
            LaserBlock block = (LaserBlock)blockEntity;
            block.setLaser(this.f_58857_, pos, direction, player);
        } else if (!enabled) {
            int boundType = direction == Direction.UP || direction == Direction.DOWN ? 1 : (direction == Direction.NORTH || direction == Direction.SOUTH ? 2 : 3);
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.m_60734_() == SCContent.LASER_FIELD.get() && (Integer)stateToCheck.m_61143_((Property)LaserFieldBlock.BOUNDTYPE) == boundType, (LevelAccessor)this.f_58857_, this.f_58858_, direction);
        }
    }

    public EnumMap<Direction, Boolean> getSideConfig() {
        return this.sideConfig;
    }

    public boolean isSideEnabled(Direction dir) {
        return !this.isModuleEnabled(ModuleType.SMART) || this.sideConfig.getOrDefault(dir, true) != false;
    }

    private void setLasersAccordingToDisabledOption() {
        if (this.isEnabled()) {
            ((LaserBlock)this.m_58900_().m_60734_()).setLaser(this.f_58857_, this.f_58858_, null);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    public ModuleType synchronizeWith(LaserBlockBlockEntity that) {
        if (!LinkableBlockEntity.isLinkedWith(this, that)) {
            Object2BooleanArrayMap bothInsertedModules = new Object2BooleanArrayMap();
            ArrayList thisInsertedModules = this.getInsertedModules();
            ArrayList thatInsertedModules = that.getInsertedModules();
            for (ModuleType moduleType : thisInsertedModules) {
                ItemStack thisModule = this.getModule(moduleType);
                if (thatInsertedModules.contains((Object)moduleType) && !thisModule.areShareTagsEqual(that.getModule(moduleType))) {
                    return moduleType;
                }
                bothInsertedModules.put(thisModule.m_41777_(), this.isModuleEnabled(moduleType));
                this.removeModule(moduleType, false);
            }
            for (ModuleType moduleType : thatInsertedModules) {
                bothInsertedModules.put(that.getModule(moduleType).m_41777_(), that.isModuleEnabled(moduleType));
                that.removeModule(moduleType, false);
                this.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(moduleType, false), that);
            }
            this.readOptions(that.writeOptions(new CompoundTag()));
            LinkableBlockEntity.link(this, that);
            for (Map.Entry entry : bothInsertedModules.entrySet()) {
                ItemStack module = (ItemStack)entry.getKey();
                ModuleItem item = (ModuleItem)module.m_41720_();
                ModuleType type = item.getModuleType();
                this.insertModule((ItemStack)entry.getKey(), false);
                this.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, false), this);
                this.toggleModuleState(type, (Boolean)entry.getValue());
                this.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, true), this);
            }
        }
        return null;
    }
}

