/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SecurityCameraBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE {
    public double cameraRotation = 0.0;
    public double oCameraRotation = 0.0;
    public boolean addToRotation = true;
    public boolean down = false;
    public boolean downSet = false;
    private int playersViewing = 0;
    private boolean shutDown = false;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption("rotationSpeed", 0.018, 0.01, 0.025, 0.001, true);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption("customRotation", this.cameraRotation, 1.55, -1.55, (Double)this.rotationSpeedOption.get(), true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);

    public SecurityCameraBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.downSet) {
            this.down = state.m_61143_((Property)SecurityCameraBlock.FACING) == Direction.DOWN;
            this.downSet = true;
        }
        if (!this.shutDown) {
            this.oCameraRotation = this.cameraRotation;
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                this.cameraRotation = (Double)this.customRotationOption.get();
                return;
            }
            if (this.addToRotation && this.cameraRotation <= (double)1.55f) {
                this.cameraRotation += ((Double)this.rotationSpeedOption.get()).doubleValue();
            } else {
                this.addToRotation = false;
            }
            if (!this.addToRotation && this.cameraRotation >= (double)-1.55f) {
                this.cameraRotation -= ((Double)this.rotationSpeedOption.get()).doubleValue();
            } else {
                this.addToRotation = true;
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("shutDown", this.shutDown);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.shutDown = tag.m_128471_("shutDown");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled};
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("disabled") && !this.f_58857_.f_46443_ && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                SecurityCamera camera;
                Entity entity = player.m_8954_();
                if (!(entity instanceof SecurityCamera) || !(camera = (SecurityCamera)entity).m_142538_().equals((Object)this.f_58858_)) continue;
                camera.stopViewing(player);
            }
        }
    }

    @Override
    public void shutDown() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        IEMPAffectedBE.super.shutDown();
        if (state.m_60734_() == SCContent.SECURITY_CAMERA.get() && ((Boolean)state.m_61143_((Property)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public void startViewing() {
        if (this.playersViewing++ == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void stopViewing() {
        if (--this.playersViewing == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

