/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Optional;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class DisguisableBlock
extends OwnableBlock
implements IOverlayDisplay,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DisguisableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isNormalCube(BlockState state, BlockGetter level, BlockPos pos) {
        DisguisableBlock disguisableBlock;
        BlockState disguisedState;
        Block block = state.m_60734_();
        if (block instanceof DisguisableBlock && (disguisedState = (disguisableBlock = (DisguisableBlock)block).getDisguisedStateOrDefault(state, level, pos)).m_60734_() != state.m_60734_()) {
            return disguisedState.m_60796_(level, pos);
        }
        return state.m_60767_().m_76337_() && state.m_60838_(level, pos);
    }

    public static boolean isSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        DisguisableBlock disguisableBlock;
        BlockState disguisedState;
        Block block = state.m_60734_();
        if (block instanceof DisguisableBlock && (disguisedState = (disguisableBlock = (DisguisableBlock)block).getDisguisedStateOrDefault(state, level, pos)).m_60734_() != state.m_60734_()) {
            return disguisedState.m_60828_(level, pos);
        }
        return state.m_60767_().m_76334_() && state.m_60838_(level, pos);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getLightEmission(level, pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60742_(level, pos, ctx);
        }
        return super.m_5939_(state, level, pos, ctx);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60768_(level, pos);
        }
        return super.m_7952_(state, level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60792_(level, pos);
        }
        return super.m_7749_(state, level, pos);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public final BlockState getDisguisedStateOrDefault(BlockState state, BlockGetter level, BlockPos pos) {
        return DisguisableBlock.getDisguisedBlockState(level, pos).orElse(state);
    }

    public static Optional<BlockState> getDisguisedBlockState(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IModuleInventory) {
            IModuleInventory be = (IModuleInventory)blockEntity;
            return DisguisableBlock.getDisguisedBlockStateFromStack(be.isModuleEnabled(ModuleType.DISGUISE) ? be.getModule(ModuleType.DISGUISE) : ItemStack.f_41583_);
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getDisguisedBlockStateFromStack(ItemStack module) {
        if (!module.m_41619_()) {
            BlockState disguisedState = NbtUtils.m_129241_((CompoundTag)module.m_41784_().m_128469_("SavedState"));
            if (disguisedState != null && disguisedState.m_60734_() != Blocks.f_50016_) {
                return Optional.of(disguisedState);
            }
            Block block = ((ModuleItem)module.m_41720_()).getBlockAddon(module.m_41783_());
            if (block != null) {
                return Optional.of(block.m_49966_());
            }
        }
        return Optional.empty();
    }

    public ItemStack getDisguisedStack(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            Block block;
            ItemStack stack;
            IModuleInventory be = (IModuleInventory)blockEntity;
            ItemStack itemStack = stack = be.isModuleEnabled(ModuleType.DISGUISE) ? be.getModule(ModuleType.DISGUISE) : ItemStack.f_41583_;
            if (!stack.m_41619_() && (block = ((ModuleItem)stack.m_41720_()).getBlockAddon(stack.m_41783_())) != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return new ItemStack((ItemLike)this);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).m_41720_() == this.m_5456_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getDisguisedStack(level, pos);
    }
}

