/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.MotionActivatedLightBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MotionActivatedLightBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)3.0, (double)13.0, (double)10.0, (double)4.0, (double)14.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)13.0, (double)10.0, (double)9.0, (double)14.0), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)7.0, (double)3.0, (double)14.0, (double)9.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)4.0, (double)14.0, (double)9.0, (double)7.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_)));
    private static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)3.0, (double)6.0, (double)3.0, (double)4.0, (double)10.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)6.0, (double)3.0, (double)9.0, (double)10.0), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)7.0, (double)2.0, (double)8.0, (double)9.0), (VoxelShape)Block.m_49796_((double)1.0, (double)4.0, (double)7.0, (double)2.0, (double)7.0, (double)9.0), (BooleanOp)BooleanOp.f_82685_)));
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)3.0, (double)2.0, (double)10.0, (double)4.0, (double)3.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)9.0, (double)3.0), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)7.0, (double)3.0, (double)0.0, (double)9.0, (double)8.0, (double)2.0), (VoxelShape)Block.m_49796_((double)7.0, (double)4.0, (double)1.0, (double)9.0, (double)7.0, (double)2.0), (BooleanOp)BooleanOp.f_82685_)));
    private static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)3.0, (double)6.0, (double)14.0, (double)4.0, (double)10.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)6.0, (double)6.0, (double)14.0, (double)9.0, (double)10.0), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)14.0, (double)3.0, (double)7.0, (double)16.0, (double)8.0, (double)9.0), (VoxelShape)Block.m_49796_((double)14.0, (double)4.0, (double)7.0, (double)15.0, (double)7.0, (double)9.0), (BooleanOp)BooleanOp.f_82685_)));

    public MotionActivatedLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> Shapes.m_83144_();
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction side = (Direction)state.m_61143_((Property)FACING);
        return side != Direction.UP && side != Direction.DOWN && BlockUtils.isSideSolid(level, pos.m_142300_(side.m_122424_()), side);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level level, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return facing != Direction.UP && facing != Direction.DOWN && BlockUtils.isSideSolid((LevelReader)level, pos.m_142300_(facing.m_122424_()), facing) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_)) : null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                inv.dropAllModules();
            }
            if (!newState.m_155947_()) {
                level.m_46747_(pos);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MotionActivatedLightBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.MOTION_LIGHT_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            case FRONT_BACK: {
                if (facing.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
        }
        return state;
    }
}

