/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonMovingBlockEntity;
import net.geforcemods.securitycraft.blockentities.ValidationOwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedMovingPistonBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.ReinforcedPistonStructureResolver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedPistonBaseBlock
extends PistonBaseBlock
implements IReinforcedBlock,
EntityBlock {
    public ReinforcedPistonBaseBlock(boolean sticky, BlockBehaviour.Properties properties) {
        super(sticky, properties);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public void m_60167_(Level level, BlockPos pos, BlockState state) {
        OwnableBlockEntity be;
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        boolean hasSignal = this.getNeighborSignal(level, pos, direction);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof OwnableBlockEntity && !(be = (OwnableBlockEntity)blockEntity).getOwner().isValidated()) {
            return;
        }
        if (hasSignal && !((Boolean)state.m_61143_((Property)f_60153_)).booleanValue()) {
            if (new ReinforcedPistonStructureResolver(level, pos, direction, true).resolve()) {
                level.m_7696_(pos, (Block)this, 0, direction.m_122411_());
            }
        } else if (!hasSignal && ((Boolean)state.m_61143_((Property)f_60153_)).booleanValue()) {
            ReinforcedPistonMovingBlockEntity pistonTileEntity;
            BlockEntity blockEntity2;
            BlockPos offsetPos = pos.m_5484_(direction, 2);
            BlockState offsetState = level.m_8055_(offsetPos);
            int i = 1;
            if (offsetState.m_60713_((Block)SCContent.REINFORCED_MOVING_PISTON.get()) && offsetState.m_61143_((Property)f_52588_) == direction && (blockEntity2 = level.m_7702_(offsetPos)) instanceof ReinforcedPistonMovingBlockEntity && (pistonTileEntity = (ReinforcedPistonMovingBlockEntity)blockEntity2).isExtending() && (pistonTileEntity.getProgress(0.0f) < 0.5f || level.m_46467_() == pistonTileEntity.getLastTicked() || ((ServerLevel)level).m_8874_())) {
                i = 2;
            }
            level.m_7696_(pos, (Block)this, i, direction.m_122411_());
        }
    }

    private boolean getNeighborSignal(Level level, BlockPos pos, Direction direction) {
        for (Direction dir : Direction.values()) {
            if (dir == direction || !level.m_46616_(pos.m_142300_(dir), dir)) continue;
            return true;
        }
        if (level.m_46616_(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos posAbove = pos.m_7494_();
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN || !level.m_46616_(posAbove.m_142300_(dir), dir)) continue;
            return true;
        }
        return false;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        if (!level.f_46443_) {
            boolean isPowered = this.getNeighborSignal(level, pos, direction);
            if (isPowered && (id == 1 || id == 2)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_60153_, (Comparable)Boolean.valueOf(true)), 2);
                return false;
            }
            if (!isPowered && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (ForgeEventFactory.onPistonMovePre((Level)level, (BlockPos)pos, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.moveBlocks(level, pos, direction, true)) {
                return false;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_60153_, (Comparable)Boolean.valueOf(true)), 67);
            level.m_5594_(null, pos, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.25f + 0.6f);
            level.m_151555_(GameEvent.f_157775_, pos);
        } else if (id == 1 || id == 2) {
            if (ForgeEventFactory.onPistonMovePre((Level)level, (BlockPos)pos, (Direction)direction, (boolean)false)) {
                return false;
            }
            BlockEntity blockEntity = level.m_7702_(pos.m_142300_(direction));
            if (blockEntity instanceof ReinforcedPistonMovingBlockEntity) {
                ReinforcedPistonMovingBlockEntity pistonBe = (ReinforcedPistonMovingBlockEntity)blockEntity;
                pistonBe.finalTick();
            }
            BlockEntity be = level.m_7702_(pos);
            BlockState movingPiston = (BlockState)((BlockState)((Block)SCContent.REINFORCED_MOVING_PISTON.get()).m_49966_().m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)MovingPistonBlock.f_60047_, (Comparable)(this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT));
            level.m_7731_(pos, movingPiston, 20);
            level.m_151523_(ReinforcedMovingPistonBlock.newMovingBlockEntity(pos, movingPiston, (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.m_122376_((int)(param & 7))), be != null ? be.m_5995_() : null, direction, false, true));
            level.m_6289_(pos, movingPiston.m_60734_());
            movingPiston.m_60701_((LevelAccessor)level, pos, 2);
            if (this.f_60160_) {
                ReinforcedPistonMovingBlockEntity pistonBe;
                BlockEntity blockEntity2;
                BlockPos offsetPos = pos.m_142082_(direction.m_122429_() * 2, direction.m_122430_() * 2, direction.m_122431_() * 2);
                BlockState offsetState = level.m_8055_(offsetPos);
                boolean flag = false;
                if (offsetState.m_60713_((Block)SCContent.REINFORCED_MOVING_PISTON.get()) && (blockEntity2 = level.m_7702_(offsetPos)) instanceof ReinforcedPistonMovingBlockEntity && (pistonBe = (ReinforcedPistonMovingBlockEntity)blockEntity2).getFacing() == direction && pistonBe.isExtending()) {
                    pistonBe.finalTick();
                    flag = true;
                }
                if (!flag) {
                    if (id != 1 || offsetState.m_60795_() || !ReinforcedPistonBaseBlock.isPushable(offsetState, level, pos, offsetPos, direction.m_122424_(), false, direction) || offsetState.m_60811_() != PushReaction.NORMAL && !offsetState.m_60713_((Block)SCContent.REINFORCED_PISTON.get()) && !offsetState.m_60713_((Block)SCContent.REINFORCED_STICKY_PISTON.get())) {
                        level.m_7471_(pos.m_142300_(direction), false);
                    } else {
                        this.moveBlocks(level, pos, direction, false);
                    }
                }
            } else {
                level.m_7471_(pos.m_142300_(direction), false);
            }
            level.m_5594_(null, pos, SoundEvents.f_12311_, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.15f + 0.6f);
            level.m_151555_(GameEvent.f_157774_, pos);
        }
        ForgeEventFactory.onPistonMovePost((Level)level, (BlockPos)pos, (Direction)direction, (id == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean isPushable(BlockState state, Level level, BlockPos pistonPos, BlockPos pos, Direction facing, boolean destroyBlocks, Direction direction) {
        if (pos.m_123342_() >= level.m_141937_() && pos.m_123342_() <= level.m_151558_() - 1 && level.m_6857_().m_61937_(pos)) {
            if (state.m_60795_()) {
                return true;
            }
            if (!(state.m_60713_(Blocks.f_50080_) || state.m_60713_(Blocks.f_50723_) || state.m_60713_(Blocks.f_50724_) || state.m_60713_((Block)SCContent.REINFORCED_OBSIDIAN.get()) || state.m_60713_((Block)SCContent.REINFORCED_CRYING_OBSIDIAN.get()))) {
                if (facing == Direction.DOWN && pos.m_123342_() == level.m_141937_() || facing == Direction.UP && pos.m_123342_() == level.m_151558_() - 1) {
                    return false;
                }
                if (!(state.m_60713_(Blocks.f_50039_) || state.m_60713_(Blocks.f_50032_) || state.m_60713_((Block)SCContent.REINFORCED_PISTON.get()) || state.m_60713_((Block)SCContent.REINFORCED_STICKY_PISTON.get()))) {
                    if (state.m_60734_() instanceof IReinforcedBlock ? !ReinforcedPistonBaseBlock.isSameOwner(pos, pistonPos, level) : state.m_60800_((BlockGetter)level, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.m_60811_()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return destroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return facing == direction;
                        }
                    }
                } else if (((Boolean)state.m_61143_((Property)f_60153_)).booleanValue()) {
                    return false;
                }
                return !state.m_155947_() || state.m_60734_() instanceof IReinforcedBlock;
            }
        }
        return false;
    }

    private boolean moveBlocks(Level level, BlockPos pos, Direction facing, boolean extending) {
        ReinforcedPistonStructureResolver structureResolver;
        BlockPos frontPos = pos.m_142300_(facing);
        BlockEntity pistonBe = level.m_7702_(pos);
        if (!extending && level.m_8055_(frontPos).m_60713_((Block)SCContent.REINFORCED_PISTON_HEAD.get())) {
            level.m_7731_(frontPos, Blocks.f_50016_.m_49966_(), 20);
        }
        if (!(structureResolver = new ReinforcedPistonStructureResolver(level, pos, facing, extending)).resolve()) {
            return false;
        }
        HashMap stateToPosMap = Maps.newHashMap();
        List<BlockPos> blocksToMove = structureResolver.getToPush();
        ArrayList statesToMove = Lists.newArrayList();
        for (int i = 0; i < blocksToMove.size(); ++i) {
            BlockPos posToMove = blocksToMove.get(i);
            BlockState stateToMove = level.m_8055_(posToMove);
            statesToMove.add(stateToMove);
            stateToPosMap.put(posToMove, stateToMove);
        }
        List<BlockPos> blocksToDestroy = structureResolver.getToDestroy();
        BlockState[] updatedBlocks = new BlockState[blocksToMove.size() + blocksToDestroy.size()];
        Direction direction = extending ? facing : facing.m_122424_();
        int j = 0;
        for (int k = blocksToDestroy.size() - 1; k >= 0; --k) {
            BlockPos posToDestroy = blocksToDestroy.get(k);
            BlockState blockState = level.m_8055_(posToDestroy);
            BlockEntity beToDestroy = blockState.m_155947_() ? level.m_7702_(posToDestroy) : null;
            ReinforcedPistonBaseBlock.m_49892_((BlockState)blockState, (LevelAccessor)level, (BlockPos)posToDestroy, (BlockEntity)beToDestroy);
            level.m_7731_(posToDestroy, Blocks.f_50016_.m_49966_(), 18);
            if (!blockState.m_204336_(BlockTags.f_13076_)) {
                level.m_142052_(posToDestroy, blockState);
            }
            updatedBlocks[j++] = blockState;
        }
        for (int l = blocksToMove.size() - 1; l >= 0; --l) {
            BlockPos posToMove = blocksToMove.get(l);
            BlockState blockState = level.m_8055_(posToMove);
            BlockState movingPiston = (BlockState)((Block)SCContent.REINFORCED_MOVING_PISTON.get()).m_49966_().m_61124_((Property)f_52588_, (Comparable)direction);
            BlockEntity beToMove = level.m_7702_(posToMove);
            CompoundTag tag = null;
            posToMove = posToMove.m_142300_(direction);
            if (beToMove != null) {
                tag = beToMove.m_187482_();
                tag.m_128405_("x", posToMove.m_123341_());
                tag.m_128405_("y", posToMove.m_123342_());
                tag.m_128405_("z", posToMove.m_123343_());
            }
            stateToPosMap.remove(posToMove);
            level.m_7731_(posToMove, (BlockState)((Block)SCContent.REINFORCED_MOVING_PISTON.get()).m_49966_().m_61124_((Property)f_52588_, (Comparable)facing), 68);
            level.m_151523_(ReinforcedMovingPistonBlock.newMovingBlockEntity(posToMove, movingPiston, (BlockState)statesToMove.get(l), tag, facing, extending, false));
            updatedBlocks[j++] = blockState;
        }
        if (extending) {
            PistonType type = this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT;
            Iterator<Object> pistonHead = (BlockState)((BlockState)((Block)SCContent.REINFORCED_PISTON_HEAD.get()).m_49966_().m_61124_((Property)PistonHeadBlock.f_52588_, (Comparable)facing)).m_61124_((Property)PistonHeadBlock.f_60235_, (Comparable)type);
            BlockState blockState = (BlockState)((BlockState)((Block)SCContent.REINFORCED_MOVING_PISTON.get()).m_49966_().m_61124_((Property)MovingPistonBlock.f_60046_, (Comparable)facing)).m_61124_((Property)MovingPistonBlock.f_60047_, (Comparable)(this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT));
            OwnableBlockEntity headBe = new OwnableBlockEntity(frontPos, blockState);
            if (pistonBe instanceof OwnableBlockEntity) {
                headBe.setOwner(((OwnableBlockEntity)pistonBe).getOwner().getUUID(), ((OwnableBlockEntity)pistonBe).getOwner().getName());
            }
            stateToPosMap.remove(frontPos);
            level.m_7731_(frontPos, blockState, 68);
            level.m_151523_(ReinforcedMovingPistonBlock.newMovingBlockEntity(frontPos, blockState, pistonHead, headBe.m_5995_(), facing, true, true));
        }
        BlockState air = Blocks.f_50016_.m_49966_();
        for (BlockPos blockPos : stateToPosMap.keySet()) {
            level.m_7731_(blockPos, air, 82);
        }
        for (Map.Entry entry : stateToPosMap.entrySet()) {
            BlockPos posToUpdate = (BlockPos)entry.getKey();
            BlockState stateToUpdate = (BlockState)entry.getValue();
            stateToUpdate.m_60758_((LevelAccessor)level, posToUpdate, 2);
            air.m_60701_((LevelAccessor)level, posToUpdate, 2);
            air.m_60758_((LevelAccessor)level, posToUpdate, 2);
        }
        j = 0;
        for (int i1 = blocksToDestroy.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = updatedBlocks[j++];
            BlockPos posToDestroy = blocksToDestroy.get(i1);
            blockState.m_60758_((LevelAccessor)level, posToDestroy, 2);
            level.m_46672_(posToDestroy, blockState.m_60734_());
        }
        for (int j1 = blocksToMove.size() - 1; j1 >= 0; --j1) {
            level.m_46672_(blocksToMove.get(j1), updatedBlocks[j++].m_60734_());
        }
        if (extending) {
            level.m_46672_(frontPos, (Block)SCContent.REINFORCED_PISTON_HEAD.get());
        }
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ValidationOwnableBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return this.f_60160_ ? Blocks.f_50032_ : Blocks.f_50039_;
    }

    private static boolean isSameOwner(BlockPos blockPos, BlockPos pistonPos, Level level) {
        BlockEntity pistonBe = level.m_7702_(pistonPos);
        IOwnable blockBe = (IOwnable)level.m_7702_(blockPos);
        if (pistonBe instanceof IOwnable) {
            IOwnable ownable = (IOwnable)pistonBe;
            return blockBe.getOwner().owns(ownable);
        }
        return false;
    }
}

