/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.google.common.base.Predicates;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.network.client.SendTip;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class SCCommand {
    private static final Map<String, DeferredRegister<?>> REGISTRIES = (Map)Util.m_137537_(() -> {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Field field : SCContent.class.getFields()) {
            if (field.getType() != DeferredRegister.class) {
                return map;
            }
            try {
                map.put(field.getName().toLowerCase(Locale.ROOT), (DeferredRegister)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return map;
    });

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"sc").requires((Predicate)Predicates.alwaysTrue())).then(SCCommand.dump())).then(SCCommand.connect())).then(SCCommand.help())).then(SCCommand.bug()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> dump() {
        return Commands.m_82127_((String)"dump").then(Commands.m_82129_((String)"registry", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(REGISTRIES.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> {
            String registry = (String)ctx.getArgument("registry", String.class);
            if (!REGISTRIES.containsKey(registry)) {
                throw new CommandRuntimeException((Component)new TranslatableComponent("messages.securitycraft:dump.notFound", new Object[]{registry}));
            }
            String lineSeparator = System.lineSeparator();
            Collection registryObjects = REGISTRIES.get(registry).getEntries();
            Object result = "";
            for (RegistryObject ro : registryObjects) {
                result = (String)result + ro.getId().toString() + lineSeparator;
            }
            String finalResult = result;
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("[").m_7220_((Component)new TextComponent("SecurityCraft").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)new TextComponent("] ")).m_7220_((Component)new TranslatableComponent("messages.securitycraft:dump.result", new Object[]{registryObjects.size()}).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(registry))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalResult.substring(0, finalResult.lastIndexOf(lineSeparator)))))), Util.f_137441_);
            return 0;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> connect() {
        return Commands.m_82127_((String)"connect").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("[").m_7220_((Component)new TextComponent("IRC").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent("] ")).m_7220_((Component)Utils.localize("messages.securitycraft:irc.connected", new Object[0])).m_7220_((Component)new TextComponent(" ")).m_7220_(ForgeHooks.newChatWithLinks((String)SendTip.tipsWithLink.get("discord"))), Util.f_137441_);
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> help() {
        return Commands.m_82127_((String)"help").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TranslatableComponent("messages.securitycraft:sc_help", new Object[]{new TranslatableComponent(Blocks.f_50091_.m_7705_()), new TranslatableComponent(Items.f_42517_.m_5524_()), new TranslatableComponent(Items.f_42025_.m_5524_())}), Util.f_137441_);
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> bug() {
        return Commands.m_82127_((String)"bug").executes(ctx -> {
            PlayerUtils.sendMessageEndingWithLink((CommandSource)((CommandSourceStack)ctx.getSource()).m_81375_(), (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:bugReport", new Object[0]), SendTip.tipsWithLink.get("discord"), ChatFormatting.GOLD);
            return 0;
        });
    }
}

