/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.top;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class TOPDataProvider
implements Function<ITheOneProbe, Void> {
    private static final MutableComponent EQUIPPED = Utils.localize("waila.securitycraft:equipped", new Object[0]).m_130940_(ChatFormatting.GRAY);
    private static final MutableComponent ALLOWLIST_MODULE = new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.ALLOWLIST.getTranslationKey())).m_130940_(ChatFormatting.GRAY);
    private static final MutableComponent DISGUISE_MODULE = new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.DISGUISE.getTranslationKey())).m_130940_(ChatFormatting.GRAY);
    private static final MutableComponent SPEED_MODULE = new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.SPEED.getTranslationKey())).m_130940_(ChatFormatting.GRAY);

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, level, blockState, data) -> {
            ItemStack disguisedAs = ItemStack.f_41583_;
            Block patt2773$temp = blockState.m_60734_();
            if (patt2773$temp instanceof DisguisableBlock) {
                DisguisableBlock disguisedBlock = (DisguisableBlock)patt2773$temp;
                disguisedAs = disguisedBlock.getDisguisedStack((BlockGetter)level, data.getPos());
            } else {
                IOverlayDisplay display;
                ItemStack displayStack;
                Block patt2927$temp = blockState.m_60734_();
                if (patt2927$temp instanceof IOverlayDisplay && (displayStack = (display = (IOverlayDisplay)patt2927$temp).getDisplayStack(level, blockState, data.getPos())) != null) {
                    disguisedAs = displayStack;
                }
            }
            if (!disguisedAs.m_41619_()) {
                probeInfo.horizontal().item(disguisedAs).vertical().itemLabel(disguisedAs).mcText((Component)new TextComponent(((ModContainer)ModList.get().getModContainerById(disguisedAs.m_41720_().getRegistryName().m_135827_()).get()).getModInfo().getDisplayName()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
                return true;
            }
            return false;
        });
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("securitycraft", "securitycraft");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData data) {
                Nameable nameable;
                IOverlayDisplay display;
                Block block = blockState.m_60734_();
                if (block instanceof IOverlayDisplay && !(display = (IOverlayDisplay)block).shouldShowSCInfo(level, blockState, data.getPos())) {
                    return;
                }
                BlockEntity be = level.m_7702_(data.getPos());
                if (be instanceof IOwnable) {
                    IOwnable ownable = (IOwnable)be;
                    probeInfo.vertical().mcText((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(ownable.getOwner())).m_130940_(ChatFormatting.GRAY));
                }
                if (be instanceof IModuleInventory) {
                    IOwnable ownable;
                    IModuleInventory inv = (IModuleInventory)be;
                    if (!(be instanceof IOwnable && !(ownable = (IOwnable)be).isOwnedBy(player) || inv.getInsertedModules().isEmpty())) {
                        probeInfo.mcText((Component)EQUIPPED);
                        for (ModuleType module : inv.getInsertedModules()) {
                            probeInfo.mcText((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent(module.getTranslationKey())).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                }
                if (be instanceof Nameable && (nameable = (Nameable)be).m_8077_()) {
                    Component text = nameable.m_7770_();
                    probeInfo.mcText((Component)Utils.localize("waila.securitycraft:customName", text == null ? TextComponent.f_131282_ : text).m_130940_(ChatFormatting.GRAY));
                }
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, Entity entity, IProbeHitEntityData data) {
                if (entity instanceof Sentry) {
                    Sentry sentry = (Sentry)entity;
                    Sentry.SentryMode mode = sentry.getMode();
                    probeInfo.mcText((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(sentry.getOwner())).m_130940_(ChatFormatting.GRAY));
                    if (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule()) {
                        probeInfo.mcText((Component)EQUIPPED);
                        if (!sentry.getAllowlistModule().m_41619_()) {
                            probeInfo.mcText((Component)ALLOWLIST_MODULE);
                        }
                        if (!sentry.getDisguiseModule().m_41619_()) {
                            probeInfo.mcText((Component)DISGUISE_MODULE);
                        }
                        if (sentry.hasSpeedModule()) {
                            probeInfo.mcText((Component)SPEED_MODULE);
                        }
                    }
                    TranslatableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
                    if (mode != Sentry.SentryMode.IDLE) {
                        modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
                    }
                    probeInfo.mcText((Component)modeDescription.m_130940_(ChatFormatting.GRAY));
                }
            }
        });
        return null;
    }
}

