/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdminToolItem
extends Item {
    public AdminToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        TranslatableComponent adminToolName = Utils.localize(this.m_5524_(), new Object[0]);
        if (((Boolean)ConfigHandler.SERVER.allowAdminTool.get()).booleanValue()) {
            if (!player.m_7500_()) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), ChatFormatting.DARK_PURPLE);
                return InteractionResult.FAIL;
            }
            InteractionResult briefcaseResult = this.handleBriefcase(player, ctx.m_43724_()).m_19089_();
            if (briefcaseResult != InteractionResult.PASS) {
                return briefcaseResult;
            }
            BlockEntity be = level.m_7702_(pos);
            if (be != null) {
                IModuleInventory inv;
                ArrayList<ModuleType> modules;
                DisplayCaseBlockEntity displayCase;
                if (be instanceof DisplayCaseBlockEntity && (displayCase = (DisplayCaseBlockEntity)be).isOpen() && displayCase.getDisplayedStack().m_41619_()) {
                    return InteractionResult.PASS;
                }
                boolean hasInfo = false;
                if (be instanceof IOwnable) {
                    IOwnable ownable = (IOwnable)be;
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.owner.name", ownable.getOwner().getName() == null ? "????" : ownable.getOwner().getName()), ChatFormatting.DARK_PURPLE);
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.owner.uuid", ownable.getOwner().getUUID() == null ? "????" : ownable.getOwner().getUUID()), ChatFormatting.DARK_PURPLE);
                    hasInfo = true;
                }
                if (be instanceof IModuleInventory && !(modules = (inv = (IModuleInventory)be).getInsertedModules()).isEmpty()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.equippedModules", new Object[0]), ChatFormatting.DARK_PURPLE);
                    for (ModuleType module : modules) {
                        PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, new TextComponent("- ").m_7220_((Component)new TranslatableComponent(module.getTranslationKey())), ChatFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (be instanceof SecretSignBlockEntity) {
                    SecretSignBlockEntity signTe = (SecretSignBlockEntity)be;
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)new TextComponent(""), ChatFormatting.DARK_PURPLE);
                    for (int i = 0; i < 4; ++i) {
                        Component text = signTe.m_155706_(i, false);
                        if (!(text instanceof MutableComponent)) continue;
                        MutableComponent mutableComponent = (MutableComponent)text;
                        PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, mutableComponent, ChatFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (!hasInfo) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), ChatFormatting.DARK_PURPLE);
                }
                return InteractionResult.SUCCESS;
            }
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), ChatFormatting.DARK_PURPLE);
        } else {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.disabled", new Object[0]), ChatFormatting.DARK_PURPLE);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!player.m_7500_()) {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), ChatFormatting.DARK_PURPLE);
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        return this.handleBriefcase(player, hand);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Player player, InteractionHand hand) {
        ItemStack adminTool = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() == SCContent.BRIEFCASE.get()) {
            ItemStack briefcase = player.m_21206_();
            TranslatableComponent adminToolName = Utils.localize(this.m_5524_(), new Object[0]);
            String ownerName = BriefcaseItem.getOwnerName(briefcase);
            String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.owner.name", ownerName.isEmpty() ? "????" : ownerName), ChatFormatting.DARK_PURPLE);
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)adminToolName, (MutableComponent)Utils.localize("messages.securitycraft:adminTool.owner.uuid", ownerUUID.isEmpty() ? "????" : ownerUUID), ChatFormatting.DARK_PURPLE);
            return InteractionResultHolder.m_19090_((Object)adminTool);
        }
        return InteractionResultHolder.m_19098_((Object)adminTool);
    }
}

