/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlayAlarmSound {
    private BlockPos bePos;
    private SoundEvent sound;
    private int soundX;
    private int soundY;
    private int soundZ;
    private float volume;
    private float pitch;

    public PlayAlarmSound() {
    }

    public PlayAlarmSound(BlockPos bePos, SoundEvent sound, float volume, float pitch) {
        this.bePos = bePos;
        this.sound = sound;
        this.soundX = (int)((float)bePos.m_123341_() * 8.0f);
        this.soundY = (int)((float)bePos.m_123342_() * 8.0f);
        this.soundZ = (int)((float)bePos.m_123343_() * 8.0f);
        this.volume = volume;
        this.pitch = pitch;
    }

    public PlayAlarmSound(FriendlyByteBuf buf) {
        this.bePos = buf.m_130135_();
        this.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buf.m_130281_());
        this.soundX = buf.readInt();
        this.soundY = buf.readInt();
        this.soundZ = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.bePos);
        buf.m_130085_(ForgeRegistries.SOUND_EVENTS.getKey((IForgeRegistryEntry)this.sound));
        buf.writeInt(this.soundX);
        buf.writeInt(this.soundY);
        buf.writeInt(this.soundZ);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        Level level = ClientHandler.getClientLevel();
        BlockEntity blockEntity = level.m_7702_(this.bePos);
        if (blockEntity instanceof AlarmBlockEntity) {
            AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
            be.playSound(level, this.getX(), this.getY(), this.getZ(), this.sound, this.volume, this.pitch);
        }
    }

    public double getX() {
        return (float)this.soundX / 8.0f;
    }

    public double getY() {
        return (float)this.soundY / 8.0f;
    }

    public double getZ() {
        return (float)this.soundZ / 8.0f;
    }
}

