/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class RemoteControlMine {
    private int x;
    private int y;
    private int z;
    private Action action;

    public RemoteControlMine() {
    }

    public RemoteControlMine(int x, int y, int z, Action action) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.action = action;
    }

    public RemoteControlMine(FriendlyByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.action = (Action)buf.m_130066_(Action.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.m_130068_((Enum)this.action);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        Level level = player.f_19853_;
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IExplosive) {
            IOwnable be;
            IExplosive explosive = (IExplosive)block;
            block = level.m_7702_(pos);
            if (block instanceof IOwnable && (be = (IOwnable)block).isOwnedBy((Player)player)) {
                this.action.act(explosive, level, pos);
            }
        }
    }

    public static enum Action {
        ACTIVATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::activateMine)),
        DEFUSE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::defuseMine)),
        DETONATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::explode));

        private final TriConsumer<IExplosive, Level, BlockPos> action;

        private Action(TriConsumer<IExplosive, Level, BlockPos> action) {
            this.action = action;
        }

        public void act(IExplosive explosive, Level level, BlockPos pos) {
            this.action.accept((Object)explosive, (Object)level, (Object)pos);
        }
    }
}

