/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;

public class SetPasscode {
    private String passcode;
    private int x;
    private int y;
    private int z;

    public SetPasscode() {
    }

    public SetPasscode(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public SetPasscode(FriendlyByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.passcode = buf.m_130136_(0x1FFFFFFF);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.m_130070_(this.passcode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        IOwnable ownable;
        IPasscodeProtected be;
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        ServerPlayer player = ctx.get().getSender();
        Level level = player.f_19853_;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IPasscodeProtected && (!((be = (IPasscodeProtected)blockEntity) instanceof IOwnable) || (ownable = (IOwnable)((Object)be)).isOwnedBy((Player)player))) {
            be.hashAndSetPasscode(this.passcode);
            if (be instanceof KeypadChestBlockEntity) {
                KeypadChestBlockEntity chestBe = (KeypadChestBlockEntity)be;
                SetPasscode.checkAndUpdateAdjacentChest(chestBe, level, pos, this.passcode, be.getSalt());
            } else if (be instanceof KeypadDoorBlockEntity) {
                KeypadDoorBlockEntity doorBe = (KeypadDoorBlockEntity)be;
                SetPasscode.checkAndUpdateAdjacentDoor(doorBe, level, pos, this.passcode, be.getSalt());
            }
        }
    }

    private static void checkAndUpdateAdjacentChest(KeypadChestBlockEntity te, Level level, BlockPos pos, String codeToSet, byte[] salt) {
        BlockPos offsetPos;
        BlockEntity otherBe;
        if (te.m_58900_().m_61143_((Property)KeypadChestBlock.f_51479_) != ChestType.SINGLE && (otherBe = level.m_7702_(offsetPos = pos.m_142300_(KeypadChestBlock.m_51584_((BlockState)te.m_58900_())))) instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity chestBe = (KeypadChestBlockEntity)otherBe;
            if (te.getOwner().owns(chestBe)) {
                chestBe.hashAndSetPasscode(codeToSet, salt);
                level.m_7260_(offsetPos, otherBe.m_58900_(), otherBe.m_58900_(), 2);
            }
        }
    }

    private static void checkAndUpdateAdjacentDoor(KeypadDoorBlockEntity be, Level level, BlockPos pos, String codeToSet, byte[] salt) {
        be.runForOtherHalf(otherBe -> {
            if (be.getOwner().owns((IOwnable)otherBe)) {
                otherBe.hashAndSetPasscode(codeToSet, salt);
                level.m_7260_(otherBe.m_58899_(), otherBe.m_58900_(), otherBe.m_58900_(), 2);
            }
        });
    }
}

