/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.GameData;

public class SetStateOnDisguiseModule {
    private BlockState state;
    private StandingOrWallType standingOrWall;

    public SetStateOnDisguiseModule() {
    }

    public SetStateOnDisguiseModule(BlockState state, StandingOrWallType standingOrWall) {
        this.state = state;
        this.standingOrWall = standingOrWall;
    }

    public SetStateOnDisguiseModule(FriendlyByteBuf buf) {
        this.state = (BlockState)GameData.getBlockStateIDMap().m_7942_(buf.readInt());
        this.standingOrWall = (StandingOrWallType)buf.m_130066_(StandingOrWallType.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(GameData.getBlockStateIDMap().m_7447_((Object)this.state));
        buf.m_130068_((Enum)this.standingOrWall);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ItemStack stack = PlayerUtils.getSelectedItemStack((Player)player, (Item)SCContent.DISGUISE_MODULE.get());
        if (!stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("SavedState", (Tag)NbtUtils.m_129202_((BlockState)this.state));
            tag.m_128405_("StandingOrWall", this.standingOrWall.ordinal());
        }
    }
}

