/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ToggleModule {
    private BlockPos pos;
    private ModuleType moduleType;

    public ToggleModule() {
    }

    public ToggleModule(BlockPos pos, ModuleType moduleType) {
        this.pos = pos;
        this.moduleType = moduleType;
    }

    public ToggleModule(FriendlyByteBuf buf) {
        this.pos = BlockPos.m_122022_((long)buf.readLong());
        this.moduleType = (ModuleType)buf.m_130066_(ModuleType.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.m_121878_());
        buf.m_130068_((Enum)this.moduleType);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        BlockEntity be = player.f_19853_.m_7702_(this.pos);
        if (be instanceof IModuleInventory) {
            IOwnable ownable;
            IModuleInventory moduleInv = (IModuleInventory)be;
            if (!(be instanceof IOwnable) || (ownable = (IOwnable)be).isOwnedBy((Player)player)) {
                if (moduleInv.isModuleEnabled(this.moduleType)) {
                    moduleInv.removeModule(this.moduleType, true);
                    if (be instanceof LinkableBlockEntity) {
                        LinkableBlockEntity linkable = (LinkableBlockEntity)be;
                        linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(this.moduleType, true), linkable);
                    }
                } else {
                    moduleInv.insertModule(moduleInv.getModule(this.moduleType), true);
                    if (be instanceof LinkableBlockEntity) {
                        LinkableBlockEntity linkable = (LinkableBlockEntity)be;
                        ItemStack stack = moduleInv.getModule(this.moduleType);
                        linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.m_41720_(), true), linkable);
                    }
                }
                if (be instanceof CustomizableBlockEntity) {
                    player.f_19853_.m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
                }
            }
        }
    }
}

