/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncAlarmSettings;
import net.geforcemods.securitycraft.screen.AlarmOptionsScreen;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.registries.ForgeRegistries;

public class AlarmScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/alarm.png");
    protected final AlarmBlockEntity be;
    private final boolean hasSmartModule;
    private final Component smartModuleTooltip;
    private final Component currentlySelectedText = Utils.localize("gui.securitycraft:alarm.currently_selected", new Object[0]).m_130940_(ChatFormatting.UNDERLINE);
    private final ResourceLocation previousSelectedSoundEvent;
    private ResourceLocation selectedSoundEvent;
    private Component selectedSoundEventText;
    private int imageWidth = 256;
    private int imageHeight = 246;
    private int leftPos;
    private int topPos;
    private SoundScrollList soundList;
    protected int previousSoundLength;
    protected int soundLength;
    protected float previousPitch;
    protected float pitch;

    public AlarmScreen(AlarmBlockEntity be, ResourceLocation selectedSoundEvent) {
        super(be.m_5446_());
        this.be = be;
        this.hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        this.smartModuleTooltip = Utils.localize(this.hasSmartModule ? "gui.securitycraft:alarm.smart_module" : "gui.securitycraft:alarm.no_smart_module", new Object[0]);
        this.previousSelectedSoundEvent = selectedSoundEvent;
        this.soundLength = this.previousSoundLength = be.getSoundLength();
        this.pitch = this.previousPitch = be.getPitch();
        this.selectSound(selectedSoundEvent);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        TranslatableComponent searchText = Utils.localize("gui.securitycraft:alarm.search", new Object[0]);
        this.soundList = (SoundScrollList)this.m_142416_((GuiEventListener)new SoundScrollList(this.f_96541_, this.imageWidth - 10, this.imageHeight - 105, this.topPos + 40, this.leftPos + 5));
        HintEditBox searchBar = (HintEditBox)this.m_142416_((GuiEventListener)new HintEditBox(this.f_96547_, this.leftPos + 30, this.topPos + 20, this.imageWidth - 60, 15, (Component)searchText));
        searchBar.setHint((Component)searchText);
        searchBar.m_94153_(s -> s.matches("[a-zA-Z0-9\\._]*"));
        searchBar.m_94151_(this.soundList::updateFilteredEntries);
        this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + this.imageWidth / 2 - 85, this.topPos + 215, 170, 20, (Component)Utils.localize("menu.options", new Object[0]), b -> Minecraft.m_91087_().pushGuiLayer((Screen)new AlarmOptionsScreen(this))));
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)GUI_TEXTURE);
        this.m_93228_(pose, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.topPos + 6), 0x404040);
        this.f_96547_.m_92889_(pose, this.currentlySelectedText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.currentlySelectedText) / 2), (float)(this.topPos + this.imageHeight - 62), 0x404040);
        this.f_96547_.m_92889_(pose, this.selectedSoundEventText, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.selectedSoundEventText) / 2), (float)(this.topPos + this.imageHeight - 49), 0x404040);
        ClientUtils.renderModuleInfo(pose, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, this.f_96543_, this.f_96544_, mouseX, mouseY);
    }

    public void selectSound(ResourceLocation eventId) {
        this.selectedSoundEvent = eventId;
        this.selectedSoundEventText = Utils.localize(this.toLanguageKey(this.selectedSoundEvent), new Object[0]);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.soundList != null && this.soundList.playingSound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(this.soundList.playingSound);
        }
        boolean changed = false;
        if (this.selectedSoundEvent != this.previousSelectedSoundEvent) {
            this.be.setSound(this.selectedSoundEvent);
            changed = true;
        }
        if (this.pitch != this.previousPitch) {
            this.be.setPitch(this.pitch);
            changed = true;
        }
        if (this.soundLength != this.previousSoundLength) {
            this.be.setSoundLength(this.soundLength);
            changed = true;
        }
        if (changed) {
            SecurityCraft.channel.sendToServer((Object)new SyncAlarmSettings(this.be.m_58899_(), this.selectedSoundEvent, this.pitch, this.soundLength));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private String toLanguageKey(ResourceLocation resourceLocation) {
        return resourceLocation.m_135827_() + "." + resourceLocation.m_135815_();
    }

    public class SoundScrollList
    extends ScrollPanel {
        public final List<SoundEvent> allSoundEvents;
        private final int slotHeight = 12;
        private final int textOffset = 11;
        private final Map<SoundEvent, Component> soundEventKeys;
        private List<SoundEvent> filteredSoundEvents;
        private SoundInstance playingSound;
        private int selectedSoundIndex;
        private int contentHeight;
        private String previousSearchText;

        public SoundScrollList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.allSoundEvents = new ArrayList<SoundEvent>(ForgeRegistries.SOUND_EVENTS.getValues());
            this.slotHeight = 12;
            this.textOffset = 11;
            this.soundEventKeys = new HashMap<SoundEvent, Component>();
            this.contentHeight = 0;
            this.previousSearchText = "";
            this.updateFilteredEntries("");
            this.scrollDistance = this.selectedSoundIndex * 12;
            int maxScroll = this.getContentHeight() - (height - this.border);
            if (this.scrollDistance > (float)maxScroll) {
                this.scrollDistance = maxScroll;
            }
        }

        protected int getContentHeight() {
            return this.contentHeight;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12;
            if (slotIndex >= 0 && slotIndex < this.filteredSoundEvents.size()) {
                Minecraft mc = Minecraft.m_91087_();
                double relativeMouseY = mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
                if (relativeMouseY < (double)this.top || relativeMouseY > (double)this.bottom) {
                    return false;
                }
                if (mouseX >= 0.0 && mouseX <= 9.0) {
                    this.playSound(this.filteredSoundEvents.get(slotIndex));
                } else if (AlarmScreen.this.hasSmartModule && mouseX > 9.0 && mouseX <= (double)(this.right - 6) && slotIndex != this.selectedSoundIndex) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    this.selectSound(slotIndex);
                }
                return true;
            }
            return false;
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            super.m_6305_(pose, mouseX, mouseY, partialTick);
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            if (slotIndex >= 0 && slotIndex < this.filteredSoundEvents.size() && mouseX >= this.left && mouseX < this.right - 6 && mouseListY >= 0 && mouseY >= this.top && mouseY <= this.bottom) {
                Component soundEventKey = this.getSoundEventComponent(this.filteredSoundEvents.get(slotIndex));
                int length = AlarmScreen.this.f_96547_.m_92852_((FormattedText)soundEventKey);
                if (length >= this.width - 6 - 11) {
                    AlarmScreen.this.m_169388_(pose, List.of(soundEventKey), Optional.empty(), this.left + 11 - 12, baseY + (12 * slotIndex + 12));
                }
            }
        }

        protected void drawPanel(PoseStack pose, int entryRight, int baseY, Tesselator tesselator, int mouseX, int mouseY) {
            Font font = Minecraft.m_91087_().f_91062_;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            int min = this.left + 11 - 2;
            if (AlarmScreen.this.hasSmartModule && slotIndex != this.selectedSoundIndex && mouseX >= min && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.filteredSoundEvents.size() && mouseY >= this.top && mouseY <= this.bottom) {
                this.renderHighlightBox(entryRight, tesselator, baseY, slotBuffer, slotIndex, min);
            }
            if (this.selectedSoundIndex >= 0) {
                this.renderHighlightBox(entryRight, tesselator, baseY, slotBuffer, this.selectedSoundIndex, min);
            }
            for (int i = 0; i < this.filteredSoundEvents.size(); ++i) {
                int yStart = baseY + 12 * i;
                if (yStart + 12 < this.top) continue;
                if (yStart > this.top + this.height) break;
                SoundEvent soundEvent = this.filteredSoundEvents.get(i);
                Component name = this.getSoundEventComponent(soundEvent);
                font.m_92889_(pose, name, (float)(this.left + 11), (float)yStart, 0xC6C6C6);
                RenderSystem.m_157179_((int)0, (ResourceLocation)GUI_TEXTURE);
                SoundScrollList.m_93143_((PoseStack)pose, (int)this.left, (int)(yStart - 1), (int)this.m_93252_(), (float)(i == slotIndex && mouseX >= this.left && mouseX < min && mouseY >= this.top && mouseY <= this.bottom ? 9.0f : 0.0f), (float)246.0f, (int)10, (int)10, (int)256, (int)256);
            }
        }

        private Component getSoundEventComponent(SoundEvent soundEvent) {
            return this.soundEventKeys.computeIfAbsent(soundEvent, t -> Utils.localize(AlarmScreen.this.toLanguageKey(soundEvent.m_11660_()), new Object[0]));
        }

        private void renderHighlightBox(int entryRight, Tesselator tesselator, int baseY, int slotBuffer, int slotIndex, int min) {
            int max = entryRight - 6;
            int slotTop = baseY + slotIndex * 12;
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            RenderSystem.m_69478_();
            RenderSystem.m_69472_();
            RenderSystem.m_69453_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
        }

        public void selectSound(int slotIndex) {
            this.selectedSoundIndex = slotIndex;
            AlarmScreen.this.selectSound(this.filteredSoundEvents.get(slotIndex).m_11660_());
        }

        public void playSound(SoundEvent soundEvent) {
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            if (this.playingSound != null) {
                soundManager.m_120399_(this.playingSound);
            }
            this.playingSound = SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)AlarmScreen.this.pitch, (float)1.0f);
            soundManager.m_120367_(this.playingSound);
        }

        public void updateFilteredEntries(String searchText) {
            this.filteredSoundEvents = new ArrayList<SoundEvent>(this.allSoundEvents.stream().filter(e -> AlarmScreen.this.toLanguageKey(e.m_11660_()).contains(searchText)).toList());
            this.recalculateContentHeight();
            this.updateSelectedSoundIndex();
            if (!searchText.equals(this.previousSearchText)) {
                this.previousSearchText = searchText;
                this.scrollDistance = 0.0f;
            }
        }

        public void recalculateContentHeight() {
            int n = this.filteredSoundEvents.size();
            Objects.requireNonNull(AlarmScreen.this.f_96547_);
            int height = n * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            this.contentHeight = height;
        }

        public void updateSelectedSoundIndex() {
            this.selectedSoundIndex = Iterables.indexOf(this.filteredSoundEvents, se -> se.m_11660_().equals((Object)AlarmScreen.this.selectedSoundEvent));
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    public class HintEditBox
    extends EditBox {
        private Component hint;

        public HintEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            super.m_6303_(pose, mouseX, mouseY, partialTick);
            if (this.m_94213_() && this.hint != null && this.f_94093_.isEmpty() && !this.m_93696_()) {
                AlarmScreen.this.f_96547_.m_92763_(pose, this.hint, (float)(this.f_93620_ + 4), (float)(this.f_93621_ + (this.f_93619_ - 8) / 2), 0xE0E0E0);
            }
        }

        public void setHint(Component hint) {
            this.hint = hint;
        }
    }
}

