/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.CheckPasscode;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CheckPasscodeScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/check_passcode.png");
    private static final Component COOLDOWN_TEXT_1 = new TranslatableComponent("gui.securitycraft:passcode.cooldown1");
    private int cooldownText1XPos;
    private IPasscodeProtected be;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private int imageWidth = 176;
    private int imageHeight = 186;
    private int leftPos;
    private int topPos;
    private CensoringEditBox keycodeTextbox;
    private boolean wasOnCooldownLastRenderTick = false;

    public CheckPasscodeScreen(BlockEntity be, Component title) {
        super(title);
        this.be = (IPasscodeProtected)be;
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.cooldownText1XPos = this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)COOLDOWN_TEXT_1) / 2;
        this.f_96541_.f_91068_.m_90926_(true);
        this.m_142416_((GuiEventListener)new CallbackCheckbox(this.f_96543_ / 2 - 37, this.f_96544_ / 2 - 55, 12, 12, (Component)new TranslatableComponent("gui.securitycraft:passcode.showPasscode"), false, newState -> this.keycodeTextbox.setCensoring(newState == false), 0x404040));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 33, this.f_96544_ / 2 - 35, 20, 20, (Component)new TextComponent("1"), b -> this.addNumberToString(1)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 35, 20, 20, (Component)new TextComponent("2"), b -> this.addNumberToString(2)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 17, this.f_96544_ / 2 - 35, 20, 20, (Component)new TextComponent("3"), b -> this.addNumberToString(3)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 33, this.f_96544_ / 2 - 10, 20, 20, (Component)new TextComponent("4"), b -> this.addNumberToString(4)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 10, 20, 20, (Component)new TextComponent("5"), b -> this.addNumberToString(5)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 17, this.f_96544_ / 2 - 10, 20, 20, (Component)new TextComponent("6"), b -> this.addNumberToString(6)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 33, this.f_96544_ / 2 + 15, 20, 20, (Component)new TextComponent("7"), b -> this.addNumberToString(7)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 8, this.f_96544_ / 2 + 15, 20, 20, (Component)new TextComponent("8"), b -> this.addNumberToString(8)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 17, this.f_96544_ / 2 + 15, 20, 20, (Component)new TextComponent("9"), b -> this.addNumberToString(9)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 33, this.f_96544_ / 2 + 40, 20, 20, (Component)new TextComponent("\u2190"), b -> this.removeLastCharacter()));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 8, this.f_96544_ / 2 + 40, 20, 20, (Component)new TextComponent("0"), b -> this.addNumberToString(0)));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 17, this.f_96544_ / 2 + 40, 20, 20, (Component)new TextComponent("\u2714"), b -> this.checkCode(this.keycodeTextbox.m_94155_())));
        this.keycodeTextbox = new CensoringEditBox(this.f_96547_, this.f_96543_ / 2 - 37, this.f_96544_ / 2 - 72, 77, 12, TextComponent.f_131282_){

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.f_93623_ && super.m_6375_(mouseX, mouseY, button);
            }

            public boolean m_94204_() {
                return this.f_93623_ && this.m_94213_();
            }
        };
        this.m_142416_((GuiEventListener)this.keycodeTextbox);
        this.keycodeTextbox.m_94199_(Integer.MAX_VALUE);
        this.keycodeTextbox.m_94153_(s -> s.matches("[0-9]*\\**"));
        if (this.be.isOnCooldown()) {
            this.toggleChildrenActive(false);
        } else {
            this.m_94718_((GuiEventListener)this.keycodeTextbox);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_6305_(pose, mouseX, mouseY, partialTick);
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.topPos + 6), 0x404040);
        if (this.be.isOnCooldown()) {
            long cooldownEnd = this.be.getCooldownEnd();
            long secondsLeft = Math.max(cooldownEnd - System.currentTimeMillis(), 0L) / 1000L + 1L;
            TranslatableComponent text = new TranslatableComponent("gui.securitycraft:passcode.cooldown2", new Object[]{secondsLeft});
            this.f_96547_.m_92889_(pose, COOLDOWN_TEXT_1, (float)this.cooldownText1XPos, (float)(this.f_96544_ / 2 + 65), 0x404040);
            this.f_96547_.m_92889_(pose, (Component)text, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)text) / 2), (float)(this.f_96544_ / 2 + 75), 0x404040);
            if (!this.wasOnCooldownLastRenderTick) {
                this.wasOnCooldownLastRenderTick = true;
            }
        } else if (this.wasOnCooldownLastRenderTick) {
            this.wasOnCooldownLastRenderTick = false;
            this.toggleChildrenActive(true);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && this.keycodeTextbox.m_94155_().length() > 0) {
            this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 0.15f, 1.0f);
        }
        if (!super.m_7933_(keyCode, scanCode, modifiers) && !this.keycodeTextbox.m_7933_(keyCode, scanCode, modifiers)) {
            if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
                this.m_7379_();
            }
            if (!(this.be.isOnCooldown() || keyCode != 257 && keyCode != 335)) {
                this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 0.15f, 1.0f);
                this.checkCode(this.keycodeTextbox.m_94155_());
            }
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!this.be.isOnCooldown() && this.isValidChar(typedChar)) {
            this.keycodeTextbox.m_5534_(typedChar, keyCode);
            this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 0.15f, 1.0f);
        }
        return true;
    }

    public void m_7522_(GuiEventListener listener) {
        AbstractWidget widget;
        if (!(listener instanceof AbstractWidget) || (widget = (AbstractWidget)listener).m_93696_()) {
            super.m_7522_(listener);
        }
    }

    private boolean isValidChar(char c) {
        for (char allowedChar : this.allowedChars) {
            if (c != allowedChar) continue;
            return true;
        }
        return false;
    }

    private void addNumberToString(int number) {
        this.keycodeTextbox.m_94164_("" + number);
    }

    private void removeLastCharacter() {
        if (this.keycodeTextbox.m_94155_().length() > 0) {
            this.keycodeTextbox.m_94180_(-1);
        }
    }

    private void toggleChildrenActive(boolean setActive) {
        this.m_6702_().forEach(listener -> {
            if (listener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)listener;
                widget.f_93623_ = setActive;
            }
        });
        this.keycodeTextbox.m_94178_(setActive);
    }

    public void checkCode(String code) {
        IModuleInventory moduleInv;
        BlockPos pos = ((BlockEntity)this.be).m_58899_();
        IPasscodeProtected iPasscodeProtected = this.be;
        if (iPasscodeProtected instanceof IModuleInventory && (moduleInv = (IModuleInventory)((Object)iPasscodeProtected)).isModuleEnabled(ModuleType.SMART)) {
            this.toggleChildrenActive(false);
        }
        this.keycodeTextbox.m_94144_("");
        SecurityCraft.channel.sendToServer((Object)new CheckPasscode(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), code));
    }

    public static class CensoringEditBox
    extends EditBox {
        private String renderedText = "";
        private boolean shouldCensor = true;

        public CensoringEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
            this.m_94151_(this::updateRenderedText);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            String originalValue = this.f_94093_;
            this.f_94093_ = this.renderedText;
            boolean success = super.m_6375_(mouseX, mouseY, button);
            this.f_94093_ = originalValue;
            return success;
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            String originalValue = this.f_94093_;
            this.f_94093_ = this.renderedText;
            super.m_6303_(pose, mouseX, mouseY, partialTick);
            this.f_94093_ = originalValue;
        }

        public void m_94208_(int position) {
            String originalValue = this.f_94093_;
            this.updateRenderedText(originalValue);
            this.f_94093_ = this.renderedText;
            super.m_94208_(position);
            this.f_94093_ = originalValue;
        }

        public void setCensoring(boolean shouldCensor) {
            this.shouldCensor = shouldCensor;
            this.updateRenderedText(this.f_94093_);
        }

        private void updateRenderedText(String original) {
            if (this.shouldCensor) {
                Object x = "";
                for (int i = 1; i <= original.length(); ++i) {
                    x = (String)x + "*";
                }
                this.renderedText = x;
            } else {
                this.renderedText = original;
            }
        }
    }
}

