/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.gui.ScrollPanel;

public class ToggleListScreen<T>
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/blank.png");
    public final Component scrollListTitle;
    public final Component smartModuleTooltip;
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private final boolean hasSmartModule;
    private final boolean hasRedstoneModule;
    private final IToggleableEntries<T> be;

    public ToggleListScreen(IToggleableEntries<T> be, Component title, Component scrollListTitle, Component noSmartModule, Component smartModule) {
        super(title);
        IModuleInventory moduleInventory;
        this.be = be;
        this.hasSmartModule = be instanceof IModuleInventory && (moduleInventory = (IModuleInventory)((Object)be)).isModuleEnabled(ModuleType.SMART);
        this.hasRedstoneModule = be instanceof IModuleInventory && (moduleInventory = (IModuleInventory)((Object)be)).isModuleEnabled(ModuleType.REDSTONE);
        this.scrollListTitle = scrollListTitle;
        this.smartModuleTooltip = this.hasSmartModule ? smartModule : noSmartModule;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 176) / 2;
        this.topPos = (this.f_96544_ - 166) / 2;
        this.m_142416_((GuiEventListener)new ToggleScrollList(this.f_96541_, 152, 106, this.topPos + 40, this.leftPos + 12));
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)GUI_TEXTURE);
        this.m_93228_(pose, this.leftPos, this.topPos, 0, 0, 176, 166);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.topPos + 6), 0x404040);
        this.f_96547_.m_92889_(pose, this.scrollListTitle, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.scrollListTitle) / 2), (float)(this.topPos + 31), 0x404040);
        ClientUtils.renderModuleInfo(pose, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, this.f_96543_, this.f_96544_, mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    public class ToggleScrollList
    extends ScrollPanel {
        private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
        private final int slotHeight = 12;
        private final int listLength;
        private final List<T> orderedFilterList;
        private final Map<T, Component> typeNames;

        public ToggleScrollList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.typeNames = new HashMap();
            this.orderedFilterList = new ArrayList(ToggleListScreen.this.be.getFilters().keySet());
            this.orderedFilterList.sort((e1, e2) -> {
                if (e1 == ToggleListScreen.this.be.getDefaultType()) {
                    return 1;
                }
                if (e2 == ToggleListScreen.this.be.getDefaultType()) {
                    return -1;
                }
                return Utils.localize(e1.toString(), new Object[0]).getString().compareTo(Utils.localize(e2.toString(), new Object[0]).getString());
            });
            this.listLength = this.orderedFilterList.size();
        }

        protected int getContentHeight() {
            Objects.requireNonNull(ToggleListScreen.this.f_96547_);
            int height = this.listLength * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex;
            if (ToggleListScreen.this.hasSmartModule && (slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12) >= 0 && slotIndex < this.listLength) {
                Minecraft mc = Minecraft.m_91087_();
                double relativeMouseY = mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
                if (relativeMouseY >= (double)this.top && relativeMouseY <= (double)this.bottom) {
                    ToggleListScreen.this.be.toggleFilter(this.orderedFilterList.get(slotIndex));
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    return true;
                }
            }
            return false;
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            int comparatorOutput;
            super.m_6305_(pose, mouseX, mouseY, partialTick);
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            int slotBottom = baseY + (slotIndex + 1) * 12;
            if (ToggleListScreen.this.hasRedstoneModule && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom && (comparatorOutput = ToggleListScreen.this.be.getComparatorOutputFunction().applyAsInt(this.orderedFilterList.get(slotIndex))) > 0) {
                ToggleListScreen.this.m_96602_(pose, (Component)new TranslatableComponent("gui.securitycraft:toggleList.comparatorOutput", new Object[]{comparatorOutput}), this.right - 8, slotBottom);
            }
        }

        protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            Font font = Minecraft.m_91087_().f_91062_;
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            if (ToggleListScreen.this.hasSmartModule && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                int min = this.left;
                int max = entryRight - 6;
                int slotTop = baseY + slotIndex * 12;
                BufferBuilder bufferBuilder = tess.m_85915_();
                RenderSystem.m_69478_();
                RenderSystem.m_69472_();
                RenderSystem.m_69453_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_85721_();
                BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
                RenderSystem.m_69493_();
                RenderSystem.m_69461_();
            }
            int i = 0;
            for (Object type : this.orderedFilterList) {
                Component name = this.typeNames.computeIfAbsent(type, t -> Utils.localize(t == ToggleListScreen.this.be.getDefaultType() ? ToggleListScreen.this.be.getDefaultTypeName() : t.toString(), new Object[0]));
                int yStart = relativeY + 12 * i;
                font.m_92889_(pose, name, (float)(this.left + this.width / 2 - font.m_92852_((FormattedText)name) / 2), (float)yStart, 0xC6C6C6);
                RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
                ToggleScrollList.m_93160_((PoseStack)pose, (int)this.left, (int)(yStart - 3), (int)14, (int)14, (float)(ToggleListScreen.this.be.getFilter(type) ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)256, (int)256);
                ++i;
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

