/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.compat.ftbteams.FTBTeamsCompat;
import net.geforcemods.securitycraft.compat.ftbteams.TeamRepresentation;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.commands.CommandSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerUtils {
    public static Player getPlayerFromName(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            List players = Minecraft.m_91087_().f_91073_.m_6907_();
            for (Player tempPlayer : players) {
                if (!tempPlayer.m_7755_().getString().equals(name)) continue;
                return tempPlayer;
            }
            return null;
        }
        List players = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        for (Player tempPlayer : players) {
            if (!tempPlayer.m_7755_().getString().equals(name)) continue;
            return tempPlayer;
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            for (AbstractClientPlayer player : Minecraft.m_91087_().f_91073_.m_6907_()) {
                if (player == null || !player.m_7755_().getString().equals(name)) continue;
                return true;
            }
            return false;
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(name) != null;
    }

    public static void sendMessageToPlayer(String playerName, MutableComponent prefix, MutableComponent text, ChatFormatting color) {
        Player player = PlayerUtils.getPlayerFromName(playerName);
        if (player != null) {
            PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
        }
    }

    public static void sendMessageToPlayer(Player player, MutableComponent prefix, MutableComponent text, ChatFormatting color) {
        PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
    }

    public static void sendMessageToPlayer(Player player, MutableComponent prefix, MutableComponent text, ChatFormatting color, boolean shouldSendFromClient) {
        if (player.f_19853_.f_46443_ == shouldSendFromClient) {
            player.m_6352_((Component)new TextComponent("[").m_7220_((Component)prefix.m_6270_(Style.f_131099_.m_131140_(color))).m_7220_((Component)new TextComponent("] ")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)).m_7220_((Component)text), Util.f_137441_);
        }
    }

    public static void sendMessageEndingWithLink(CommandSource sender, MutableComponent prefix, MutableComponent text, String link, ChatFormatting color) {
        sender.m_6352_((Component)new TextComponent("[").m_7220_((Component)prefix.m_6270_(Style.f_131099_.m_131140_(color))).m_7220_((Component)new TextComponent("] ")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)).m_7220_((Component)text).m_7220_((Component)new TextComponent(": ")).m_7220_(ForgeHooks.newChatWithLinks((String)link)), Util.f_137441_);
    }

    public static boolean isHoldingItem(Player player, Supplier<Item> item, InteractionHand hand) {
        return PlayerUtils.isHoldingItem(player, item.get(), hand);
    }

    public static boolean isHoldingItem(Player player, Item item, InteractionHand hand) {
        if (hand != InteractionHand.OFF_HAND && !player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == item) {
            return true;
        }
        if (hand != InteractionHand.MAIN_HAND && !player.m_21120_(InteractionHand.OFF_HAND).m_41619_() && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == item) {
            return true;
        }
        return item == null;
    }

    public static ItemStack getSelectedItemStack(Player player, Item item) {
        return PlayerUtils.getSelectedItemStack(player.m_150109_(), item);
    }

    public static ItemStack getSelectedItemStack(Inventory inventory, Item item) {
        if (!inventory.m_36056_().m_41619_() && inventory.m_36056_().m_41720_() == item) {
            return inventory.m_36056_();
        }
        if (!((ItemStack)inventory.f_35976_.get(0)).m_41619_() && ((ItemStack)inventory.f_35976_.get(0)).m_41720_() == item) {
            return (ItemStack)inventory.f_35976_.get(0);
        }
        return ItemStack.f_41583_;
    }

    public static boolean isPlayerMountedOnCamera(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.f_19853_.f_46443_) {
            return ClientHandler.isPlayerMountedOnCamera();
        }
        return ((ServerPlayer)player).m_8954_() instanceof SecurityCamera;
    }

    public static boolean areOnSameTeam(Owner owner1, Owner owner2) {
        if (owner1.equals(owner2)) {
            return true;
        }
        if (ModList.get().isLoaded("ftbteams")) {
            return FTBTeamsCompat.areOnSameTeam(owner1, owner2);
        }
        PlayerTeam team = PlayerUtils.getPlayersVanillaTeam(owner1.getName());
        return team != null && team.m_6809_().contains(owner2.getName());
    }

    public static PlayerTeam getPlayersVanillaTeam(String playerName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_129896_().m_83500_(playerName);
        }
        return ClientHandler.getClientPlayer().m_36329_().m_83500_(playerName);
    }

    public static Component getOwnerComponent(Owner owner) {
        TeamRepresentation teamRepresentation;
        if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && (teamRepresentation = TeamRepresentation.get(owner)) != null) {
            return Utils.localize("messages.securitycraft:teamOwner", new TextComponent(teamRepresentation.name()).m_130948_(Style.f_131099_.m_178520_(teamRepresentation.color()))).m_130940_(ChatFormatting.GRAY);
        }
        return new TextComponent(owner.getName());
    }

    public static Owner getSkullOwner(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
        if (stack.m_41720_() == Items.f_42680_ && stack.m_41782_()) {
            CompoundTag stackTag = stack.m_41783_();
            if (stackTag.m_128425_("SkullOwner", 8)) {
                return new Owner(stackTag.m_128461_("SkullOwner"), "ownerUUID");
            }
            if (stackTag.m_128425_("SkullOwner", 10)) {
                GameProfile profile = NbtUtils.m_129228_((CompoundTag)stackTag.m_128469_("SkullOwner"));
                String name = "ownerName";
                String uuid = "ownerUUID";
                if (profile.getName() != null) {
                    name = profile.getName();
                }
                if (profile.getId() != null) {
                    uuid = profile.getId().toString();
                }
                return new Owner(name, uuid);
            }
        }
        return null;
    }
}

