/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class ExcavatorHandler {
    private static final Multimap<ResourceKey<Level>, MineralVein> MINERAL_VEIN_LIST = ArrayListMultimap.create();
    private static final Map<Pair<ResourceKey<Level>, ColumnPos>, MineralWorldInfo> MINERAL_INFO_CACHE = new HashMap<Pair<ResourceKey<Level>, ColumnPos>, MineralWorldInfo>();
    static final SetRestrictedField<Runnable> MARK_SAVE_DATA_DIRTY = SetRestrictedField.common();
    public static int mineralVeinYield = 0;
    public static double initialVeinDepletion = 0.0;
    public static double mineralNoiseThreshold = 0.0;
    public static PerlinSimplexNoise noiseGenerator;

    @Nullable
    public static MineralVein getRandomMineral(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return null;
        }
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, pos);
        return info.getMineralVein(ApiUtils.RANDOM);
    }

    public static Multimap<ResourceKey<Level>, MineralVein> getMineralVeinList() {
        return MINERAL_VEIN_LIST;
    }

    public static MineralWorldInfo getMineralWorldInfo(Level world, BlockPos pos) {
        return ExcavatorHandler.getMineralWorldInfo(world, new ColumnPos(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MineralWorldInfo getMineralWorldInfo(Level world, ColumnPos columnPos) {
        if (world.f_46443_) {
            return null;
        }
        ResourceKey dimension = world.m_46472_();
        Pair cacheKey = Pair.of((Object)dimension, (Object)columnPos);
        Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MineralWorldInfo worldInfo = MINERAL_INFO_CACHE.get(cacheKey);
            if (worldInfo == null) {
                ArrayList<Pair> inVeins = new ArrayList<Pair>();
                double totalSaturation = 0.0;
                Iterator iterator = MINERAL_VEIN_LIST.get((Object)dimension).iterator();
                while (iterator.hasNext()) {
                    MineralVein vein;
                    long dX = vein.getPos().f_140723_ - columnPos.f_140723_;
                    long dZ = vein.getPos().f_140724_ - columnPos.f_140724_;
                    long d = dX * dX + dZ * dZ;
                    vein = (MineralVein)iterator.next();
                    double rSq = vein.getRadius() * vein.getRadius();
                    if (!((double)d < rSq)) continue;
                    double saturation = 1.0 - (double)d / rSq;
                    inVeins.add(Pair.of((Object)vein, (Object)saturation));
                    totalSaturation += saturation;
                }
                double finalTotalSaturation = totalSaturation;
                worldInfo = new MineralWorldInfo(inVeins.stream().map(pair -> Pair.of((Object)((MineralVein)pair.getFirst()), (Object)((int)((Double)pair.getSecond() / finalTotalSaturation * 1000.0)))).filter(p -> ((MineralVein)p.getFirst()).getMineral(world) != null).collect(Collectors.toList()));
                MINERAL_INFO_CACHE.put((Pair<ResourceKey<Level>, ColumnPos>)cacheKey, worldInfo);
            }
            return worldInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePotentialVein(Level world, ChunkPos chunkpos, Random rand) {
        int xStart = chunkpos.m_45604_();
        int zStart = chunkpos.m_45605_();
        double d0 = 0.0625;
        ColumnPos pos = null;
        double maxNoise = 0.0;
        for (int xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                double noise = noiseGenerator.m_75449_((double)(xStart + xx) * d0, (double)(zStart + zz) * d0, true) * 0.55;
                double chance = Math.abs(noise) / 0.55;
                if (!(chance > mineralNoiseThreshold) || !(chance > maxNoise)) continue;
                pos = new ColumnPos(xStart + xx, zStart + zz);
                maxNoise = chance;
            }
        }
        if (pos != null) {
            Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
            synchronized (multimap) {
                ColumnPos finalPos = pos;
                int radius = 12 + rand.nextInt(32);
                int radiusSq = radius * radius;
                boolean crossover = MINERAL_VEIN_LIST.get((Object)world.m_46472_()).stream().anyMatch(vein -> {
                    long dX = vein.getPos().f_140723_ - finalPos.f_140723_;
                    long dZ = vein.getPos().f_140724_ - finalPos.f_140724_;
                    long dSq = dX * dX + dZ * dZ;
                    return dSq < (long)(vein.getRadius() * vein.getRadius()) || dSq < (long)radiusSq;
                });
                if (!crossover) {
                    IESerializableRecipe mineralMix = null;
                    MineralSelection selection = new MineralSelection(world);
                    if (selection.getTotalWeight() > 0) {
                        int weight = selection.getRandomWeight(rand);
                        for (MineralMix e : selection.getMinerals()) {
                            if ((weight -= e.weight) >= 0) continue;
                            mineralMix = e;
                            break;
                        }
                    }
                    if (mineralMix != null) {
                        MineralVein vein2 = new MineralVein(pos, mineralMix.m_6423_(), radius);
                        if (initialVeinDepletion > 0.0) {
                            vein2.setDepletion((int)((double)mineralVeinYield * (rand.nextDouble() * initialVeinDepletion)));
                        }
                        ExcavatorHandler.addVein((ResourceKey<Level>)world.m_46472_(), vein2);
                        MARK_SAVE_DATA_DIRTY.getValue().run();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVein(ResourceKey<Level> dimension, MineralVein vein) {
        Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MINERAL_VEIN_LIST.put(dimension, (Object)vein);
            ExcavatorHandler.resetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MINERAL_INFO_CACHE.clear();
        }
    }

    public static void setSetDirtyCallback(Runnable setDirty) {
        MARK_SAVE_DATA_DIRTY.setValue(setDirty);
    }

    public static class MineralSelection {
        private final int totalWeight;
        private final Set<MineralMix> validMinerals;

        public MineralSelection(Level dimension) {
            int weight = 0;
            this.validMinerals = new HashSet<MineralMix>();
            for (MineralMix e : MineralMix.RECIPES.getRecipes(dimension)) {
                if (!e.validDimension((ResourceKey<Level>)dimension.m_46472_())) continue;
                this.validMinerals.add(e);
                weight += e.weight;
            }
            this.totalWeight = weight;
        }

        public int getTotalWeight() {
            return this.totalWeight;
        }

        public int getRandomWeight(Random random) {
            return random.nextInt(this.totalWeight);
        }

        public Set<MineralMix> getMinerals() {
            return this.validMinerals;
        }
    }
}

