/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BottlingMachineBlockEntity
extends PoweredMultiblockBlockEntity<BottlingMachineBlockEntity, BottlingMachineRecipe>
implements ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds,
IEClientTickableBE,
IEBlockInterfaces.IHammerInteraction {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_LIFT_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000)};
    private boolean allowPartialFill = false;
    private final CapabilityReference<IItemHandler> outputCap = CapabilityReference.forBlockEntityAt(this, () -> {
        Direction outDir = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        return new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(2, 1, 1)).m_142300_(outDir), outDir.m_122424_());
    }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new BottlingMachineInventoryHandler(this)));
    private final MultiblockCapability<IFluidHandler> fluidCap = MultiblockCapability.make(this, be -> be.fluidCap, MultiblockPartBlockEntity::master, this.registerFluidInput((IFluidTank[])this.tanks));

    public BottlingMachineBlockEntity(BlockEntityType<BottlingMachineBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.BOTTLING_MACHINE, 16000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.m_128469_("tank"));
        this.allowPartialFill = nbt.m_128471_("allowPartialFill");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128365_("tank", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
        nbt.m_128379_("allowPartialFill", this.allowPartialFill);
    }

    @Override
    public void tickClient() {
        if (this.isRSDisabled()) {
            return;
        }
        for (MultiblockProcess process : this.processQueue) {
            float fProcess = process.processTick;
            Player localPlayer = ImmersiveEngineering.proxy.getClientPlayer();
            if (!(fProcess >= 7.0f) || !(fProcess < 9.0f)) continue;
            this.f_58857_.m_5594_(localPlayer, this.m_58899_(), IESounds.bottling, SoundSource.BLOCKS, 0.125f, 0.8f);
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (new BlockPos(1, 0, 0).equals((Object)this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (this.posInMultiblock.m_123342_() == 0 || new BlockPos(2, 1, 0).equals((Object)this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (this.posInMultiblock.m_123343_() == 1 && this.posInMultiblock.m_123342_() == 1) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        if (new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
        }
        if (new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) {
            float xMax;
            float zMin;
            float xMin;
            Direction f;
            Direction direction = f = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            float f2 = f == Direction.EAST ? -0.0625f : (f == Direction.WEST ? 0.25f : (this.getFacing() == Direction.WEST ? 0.125f : (xMin = this.getFacing() == Direction.EAST ? 0.25f : 0.0f)));
            float f3 = this.getFacing() == Direction.NORTH ? 0.125f : (this.getFacing() == Direction.SOUTH ? 0.25f : (f == Direction.SOUTH ? -0.0625f : (zMin = f == Direction.NORTH ? 0.25f : 0.0f)));
            float f4 = f == Direction.EAST ? 0.75f : (f == Direction.WEST ? 1.0625f : (this.getFacing() == Direction.WEST ? 0.75f : (xMax = this.getFacing() == Direction.EAST ? 0.875f : 1.0f)));
            float zMax = this.getFacing() == Direction.NORTH ? 0.75f : (this.getFacing() == Direction.SOUTH ? 0.875f : (f == Direction.SOUTH ? 0.75f : (f == Direction.NORTH ? 1.0625f : 1.0f)));
            return Shapes.m_83048_((double)xMin, (double)0.0625, (double)zMin, (double)xMax, (double)0.6875, (double)zMax);
        }
        if (new BlockPos(1, 2, 1).equals((Object)this.posInMultiblock)) {
            float xMin = this.getFacing() == Direction.WEST ? 0.0f : 0.21875f;
            float zMin = this.getFacing() == Direction.NORTH ? 0.0f : 0.21875f;
            float xMax = this.getFacing() == Direction.EAST ? 1.0f : 0.78125f;
            float zMax = this.getFacing() == Direction.SOUTH ? 1.0f : 0.78125f;
            return Shapes.m_83048_((double)xMin, (double)-0.4375, (double)zMin, (double)xMax, (double)0.5625, (double)zMax);
        }
        if (new BlockPos(1, 2, 0).equals((Object)this.posInMultiblock)) {
            float xMax;
            float zMin;
            float xMin;
            float f = this.getFacing() == Direction.WEST ? 0.8125f : (xMin = this.getFacing() == Direction.EAST ? 0.0f : 0.125f);
            float f5 = this.getFacing() == Direction.NORTH ? 0.8125f : (zMin = this.getFacing() == Direction.SOUTH ? 0.0f : 0.125f);
            float f6 = this.getFacing() == Direction.WEST ? 1.0f : (xMax = this.getFacing() == Direction.EAST ? 0.1875f : 0.875f);
            float zMax = this.getFacing() == Direction.NORTH ? 1.0f : (this.getFacing() == Direction.SOUTH ? 0.1875f : 0.875f);
            return Shapes.m_83048_((double)xMin, (double)-1.0, (double)zMin, (double)xMax, (double)0.25, (double)zMax);
        }
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 0, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && !world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (entity.m_6084_()) {
                MultiblockProcessBottling process;
                NonNullList<ItemStack> displayStacks;
                BottlingMachineBlockEntity master = (BottlingMachineBlockEntity)this.master();
                if (master == null) {
                    return;
                }
                List<Pair> itemsOnConveyor = this.f_58857_.m_45976_(ItemEntity.class, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)this.m_58899_()))).stream().map(itemEntity1 -> Pair.of((Object)itemEntity1, (Object)itemEntity1.m_32055_())).toList();
                if (itemsOnConveyor.isEmpty()) {
                    return;
                }
                ItemStack[] stacks = (ItemStack[])itemsOnConveyor.stream().map(Pair::getSecond).toArray(ItemStack[]::new);
                BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe(master.f_58857_, stacks, master.tanks[0].getFluid());
                if (recipe == null && !Utils.isFluidRelatedItemStack(stacks[0])) {
                    return;
                }
                if (recipe == null) {
                    displayStacks = Utils.createNonNullItemStackListFromItemStack(stacks[0]);
                    process = new MultiblockProcessBottling(displayStacks);
                } else {
                    displayStacks = recipe.getDisplayStacks(stacks);
                    process = new MultiblockProcessBottling(recipe.m_6423_(), this::getRecipeForId, displayStacks);
                }
                if (master.addProcessToQueue(process, true)) {
                    master.addProcessToQueue(process, false);
                    for (ItemStack stack : displayStacks) {
                        itemsOnConveyor.stream().filter(t -> ItemStack.m_150942_((ItemStack)((ItemStack)t.getSecond()), (ItemStack)stack)).findFirst().ifPresent(t -> {
                            ItemStack remaining = ((ItemStack)t.getSecond()).m_41777_();
                            remaining.m_41774_(stack.m_41613_());
                            ((ItemEntity)t.getFirst()).m_32045_(remaining);
                            if (remaining.m_41619_()) {
                                ((ItemEntity)t.getFirst()).m_146870_();
                            }
                        });
                    }
                }
            }
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<BottlingMachineRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).m_41619_()) {
            Direction outDir = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            BlockPos pos = this.m_58899_().m_5484_(outDir, 2);
            Utils.dropStackAtPos(this.f_58857_, pos, output, outDir);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<BottlingMachineRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 2;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 2;
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getLiftTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<BottlingMachineRecipe> process) {
        float maxTicks = process.getMaxTicks(this.f_58857_);
        return 1.0f - (BottlingMachineBlockEntity.getTransportTime(maxTicks) + BottlingMachineBlockEntity.getLiftTime(maxTicks)) / maxTicks;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public BottlingMachineRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected BottlingMachineRecipe getRecipeForId(Level level, ResourceLocation id) {
        return BottlingMachineRecipe.RECIPES.getById(level, id);
    }

    @Override
    @Nullable
    protected MultiblockProcess<BottlingMachineRecipe> loadProcessFromNBT(CompoundTag tag) {
        NonNullList inputs = NonNullList.m_122780_((int)tag.m_128451_("numInputs"), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)inputs);
        if (tag.m_128471_("isFilling")) {
            return new MultiblockProcessBottling((NonNullList<ItemStack>)inputs);
        }
        ResourceLocation id = new ResourceLocation(tag.m_128461_("recipe"));
        return new MultiblockProcessBottling(id, this::getRecipeForId, (NonNullList<ItemStack>)inputs);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || BlockPos.f_121853_.equals((Object)this.posInMultiblock) && facing.m_122434_().m_122479_())) {
            return this.fluidCap.getAndCast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && facing == (this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_())) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(2, 1, 1).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_()};
        }
        return new Direction[0];
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (player.m_6047_()) {
            BottlingMachineBlockEntity master;
            if (!this.f_58857_.f_46443_ && (master = (BottlingMachineBlockEntity)this.master()) != null) {
                master.allowPartialFill = !master.allowPartialFill;
                player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.info.bottling_machine." + (master.allowPartialFill ? "partialFill" : "completeFill")), true);
                this.updateMasterBlock(null, true);
            }
            return true;
        }
        return false;
    }

    public static class BottlingMachineInventoryHandler
    extends PoweredMultiblockBlockEntity.MultiblockInventoryHandler_DirectProcessing<BottlingMachineBlockEntity, BottlingMachineRecipe> {
        public BottlingMachineInventoryHandler(BottlingMachineBlockEntity multiblock) {
            super(multiblock);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            MultiblockProcessBottling process;
            stack = stack.m_41777_();
            BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe(((BottlingMachineBlockEntity)this.multiblock).f_58857_, new ItemStack[]{stack}, ((BottlingMachineBlockEntity)this.multiblock).tanks[0].getFluid());
            if (recipe == null && !Utils.isFluidRelatedItemStack(stack)) {
                return stack;
            }
            int inputAmount = 1;
            if (recipe == null) {
                process = new MultiblockProcessBottling(Utils.createNonNullItemStackListFromItemStack(stack.m_41777_()));
            } else {
                ItemStack displayStack = recipe.getDisplayStack(stack);
                process = new MultiblockProcessBottling(recipe.m_6423_(), ((BottlingMachineBlockEntity)this.multiblock)::getRecipeForId, Utils.createNonNullItemStackListFromItemStack(displayStack));
                inputAmount = displayStack.m_41613_();
            }
            if (((BottlingMachineBlockEntity)this.multiblock).addProcessToQueue(process, simulate)) {
                ((BottlingMachineBlockEntity)this.multiblock).m_6596_();
                ((BottlingMachineBlockEntity)this.multiblock).markContainingBlockForUpdate(null);
                stack.m_41774_(inputAmount);
                if (stack.m_41613_() <= 0) {
                    stack = ItemStack.f_41583_;
                }
            }
            return stack;
        }
    }

    public static class MultiblockProcessBottling
    extends MultiblockProcessInWorld<BottlingMachineRecipe> {
        private final boolean isFilling;
        private final NonNullList<ItemStack> filledContainer = Utils.createNonNullItemStackListFromItemStack(ItemStack.f_41583_);
        private static final BottlingMachineRecipe DUMMY_RECIPE = new BottlingMachineRecipe(new ResourceLocation("immersiveengineering", "bottling_dummy_recipe"), List.of(Lazy.of(() -> ItemStack.f_41583_)), IngredientWithSize.of(ItemStack.f_41583_), new FluidTagInput((TagKey<Fluid>)FluidTags.f_13131_, 0));

        public MultiblockProcessBottling(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, BottlingMachineRecipe> getRecipe, NonNullList<ItemStack> inputItem) {
            super(recipeId, getRecipe, 0.45f, inputItem);
            this.isFilling = false;
        }

        public MultiblockProcessBottling(NonNullList<ItemStack> inputItem) {
            super(DUMMY_RECIPE.m_6423_(), (Level level, ResourceLocation resourceLocation) -> DUMMY_RECIPE, 0.45f, inputItem);
            this.isFilling = true;
            this.filledContainer.set(0, (Object)((ItemStack)inputItem.get(0)));
        }

        @Override
        public void doProcessTick(PoweredMultiblockBlockEntity<?, BottlingMachineRecipe> multiblock) {
            super.doProcessTick(multiblock);
            BottlingMachineBlockEntity bottlingMachine = (BottlingMachineBlockEntity)multiblock;
            float transPoint = (float)this.getMaxTicks(multiblock.m_58904_()) * this.transformationPoint;
            if ((float)this.processTick >= transPoint && (float)this.processTick < 1.0f + transPoint) {
                FluidStack fs = bottlingMachine.tanks[0].getFluid();
                if (!fs.isEmpty()) {
                    if (this.isFilling) {
                        ItemStack ret = FluidUtils.fillFluidContainer((IFluidHandler)bottlingMachine.tanks[0], (ItemStack)this.filledContainer.get(0), ItemStack.f_41583_, null);
                        if (!ret.m_41619_()) {
                            this.filledContainer.set(0, (Object)ret);
                        }
                        if (!bottlingMachine.allowPartialFill && !FluidUtils.isFluidContainerFull(ret)) {
                            --this.processTick;
                        }
                    } else {
                        bottlingMachine.tanks[0].drain(((BottlingMachineRecipe)this.getRecipe((Level)multiblock.m_58904_())).fluidInput.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                multiblock.markContainingBlockForUpdate(null);
            }
        }

        @Override
        public List<ItemStack> getDisplayItem(Level level) {
            if (this.isFilling) {
                return this.filledContainer;
            }
            return super.getDisplayItem(level);
        }

        @Override
        protected List<ItemStack> getRecipeItemOutputs(PoweredMultiblockBlockEntity<?, BottlingMachineRecipe> multiblock) {
            if (this.isFilling) {
                return this.filledContainer;
            }
            return super.getRecipeItemOutputs(multiblock);
        }

        @Override
        public void writeExtraDataToNBT(CompoundTag nbt) {
            super.writeExtraDataToNBT(nbt);
            nbt.m_128379_("isFilling", this.isFilling);
        }
    }
}

