/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.client.utils.TimestampFormat;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class CoresampleItem
extends IEBaseItem {
    public CoresampleItem() {
        super(new Item.Properties().m_41491_(ImmersiveEngineering.ITEM_GROUP));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        CoresampleItem.getCoresampleInfo(stack, list, ChatFormatting.GRAY, world, true, true);
    }

    public static void getCoresampleInfo(ItemStack coresample, List<Component> list, ChatFormatting baseColor, @Nullable Level world, boolean showYield, boolean showTimestamp) {
        ColumnPos coords;
        if (coresample.m_41784_().m_128441_("coords")) {
            list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.outdated"));
        }
        if ((coords = CoresampleItem.getCoords(coresample)) != null) {
            ColumnPos pos;
            List<VeinSampleData> veins = CoresampleItem.getVeins(world, coresample);
            if (!veins.isEmpty()) {
                veins.forEach(data -> {
                    TextComponent component = new TextComponent(Utils.formatDouble(data.getPercentageInTotalSample() * 100.0, "0.00") + "% ");
                    MineralMix mineral = data.getType();
                    component.m_7220_((Component)new TranslatableComponent(mineral.getTranslationKey()));
                    list.add((Component)component.m_130940_(baseColor));
                    if (showYield) {
                        component = new TextComponent("  ");
                        component.m_7220_((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.saturation", new Object[]{Utils.formatDouble(data.getSaturation() * 100.0, "0.00")}));
                        list.add((Component)component.m_130940_(ChatFormatting.DARK_GRAY));
                        component = new TextComponent("  ");
                        int yield_ = ExcavatorHandler.mineralVeinYield - data.getDepletion();
                        yield_ = (int)((float)yield_ * (1.0f - mineral.failChance));
                        if (ExcavatorHandler.mineralVeinYield == 0) {
                            component.m_7220_((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.infinite"));
                        } else {
                            component.m_7220_((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.yield", new Object[]{yield_}));
                        }
                        list.add((Component)component.m_130940_(ChatFormatting.DARK_GRAY));
                    }
                });
            } else {
                list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.noMineral").m_130940_(baseColor));
            }
            ResourceKey<Level> dimension = CoresampleItem.getDimension(coresample);
            if (dimension != null) {
                String s2 = dimension.m_135782_().m_135815_();
                if (s2.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                    s2 = s2.substring(4);
                }
                list.add((Component)new TextComponent(Utils.toCamelCase(s2)).m_130940_(baseColor));
            }
            if ((pos = CoresampleItem.getCoords(coresample)) != null) {
                list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.pos", new Object[]{pos.f_140723_, pos.f_140724_}).m_130940_(baseColor));
            }
            if (showTimestamp) {
                boolean hasStamp = ItemNBTHelper.hasKey(coresample, "timestamp");
                if (hasStamp && world != null) {
                    long timestamp = ItemNBTHelper.getLong(coresample, "timestamp");
                    long dist = world.m_46467_() - timestamp;
                    if (dist < 0L) {
                        list.add((Component)new TextComponent("Somehow this sample is dated in the future...are you a time traveller?!").m_130940_(ChatFormatting.RED));
                    } else {
                        list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.timestamp", new Object[]{TimestampFormat.formatTimestamp(dist, TimestampFormat.DHM)}).m_130940_(baseColor));
                    }
                } else if (hasStamp) {
                    list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.timezone").m_130940_(baseColor));
                } else {
                    list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.noTimestamp").m_130940_(baseColor));
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        if (player != null && player.m_6144_()) {
            BlockPlaceContext blockCtx;
            Level world = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            Direction side = ctx.m_43719_();
            BlockState state = world.m_8055_(pos);
            if (!state.m_60629_(blockCtx = new BlockPlaceContext(ctx))) {
                pos = pos.m_142300_(side);
            }
            if (!stack.m_41619_() && player.m_36204_(pos, side, stack) && world.m_8055_(pos).m_60629_(blockCtx)) {
                BlockState coresample = IEBlocks.StoneDecoration.CORESAMPLE.defaultBlockState();
                if (world.m_7731_(pos, coresample, 3)) {
                    ((IEBaseBlock)IEBlocks.StoneDecoration.CORESAMPLE.get()).onIEBlockPlacedBy(blockCtx, coresample);
                    SoundType soundtype = world.m_8055_(pos).m_60734_().getSoundType(world.m_8055_(pos), (LevelReader)world, pos, (Entity)player);
                    world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6225_(ctx);
    }

    public static MineralMix[] getMineralMixes(Level level, ItemStack coresample) {
        return (MineralMix[])CoresampleItem.getVeins(level, coresample).stream().map(VeinSampleData::getType).toArray(MineralMix[]::new);
    }

    public static ListTag getSimplifiedMineralList(Level level, ItemStack coresample) {
        ListTag outList = new ListTag();
        CoresampleItem.getVeins(level, coresample).stream().map(VeinSampleData::getType).map(IESerializableRecipe::m_6423_).map(ResourceLocation::toString).map(StringTag::m_129297_).forEach(arg_0 -> outList.add(arg_0));
        return outList;
    }

    public static void setMineralInfo(Level level, ItemStack stack, MineralWorldInfo info, BlockPos pos) {
        if (info == null) {
            return;
        }
        List<Pair<MineralVein, Integer>> veins = info.getAllVeins();
        ListTag nbtList = new ListTag();
        veins.forEach(pair -> {
            VeinSampleData sampleData = new VeinSampleData(((MineralVein)pair.getFirst()).getMineral(level), (double)((Integer)pair.getSecond()).intValue() / (double)info.getTotalWeight(), 1.0 - ((MineralVein)pair.getFirst()).getFailChance(pos), ((MineralVein)pair.getFirst()).getDepletion());
            nbtList.add((Object)sampleData.toNBT());
        });
        stack.m_41784_().m_128365_("mineralInfo", (Tag)nbtList);
    }

    public static List<VeinSampleData> getVeins(@Nullable Level level, ItemStack stack) {
        if (level == null || !ItemNBTHelper.hasKey(stack, "mineralInfo", 9)) {
            return ImmutableList.of();
        }
        ArrayList<VeinSampleData> veins = new ArrayList<VeinSampleData>();
        ListTag mineralInfoNBT = stack.m_41784_().m_128437_("mineralInfo", 10);
        for (Tag vein : mineralInfoNBT) {
            VeinSampleData data = VeinSampleData.fromNBT(level, (CompoundTag)vein);
            if (data == null) continue;
            veins.add(data);
        }
        return veins;
    }

    @Nullable
    public static ColumnPos getCoords(@Nullable ItemStack stack) {
        if (stack != null && stack.m_41782_() && stack.m_41784_().m_128441_("x")) {
            return new ColumnPos(stack.m_41784_().m_128451_("x"), stack.m_41784_().m_128451_("z"));
        }
        return null;
    }

    public static void setCoords(ItemStack stack, BlockPos pos) {
        stack.m_41784_().m_128405_("x", pos.m_123341_());
        stack.m_41784_().m_128405_("z", pos.m_123343_());
    }

    @Nullable
    public static ResourceKey<Level> getDimension(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41784_().m_128441_("dimension")) {
            ResourceLocation name = new ResourceLocation(stack.m_41784_().m_128461_("dimension"));
            return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)name);
        }
        return null;
    }

    public static void setDimension(ItemStack stack, ResourceKey<Level> dimension) {
        stack.m_41784_().m_128359_("dimension", dimension.m_135782_().toString());
    }

    public static class VeinSampleData {
        private final MineralMix type;
        private final double percentageInTotalSample;
        private final double saturation;
        private final int depletion;

        public VeinSampleData(MineralMix type, double percentageInTotalSample, double saturation, int depletion) {
            this.type = type;
            this.percentageInTotalSample = percentageInTotalSample;
            this.saturation = saturation;
            this.depletion = depletion;
        }

        @Nullable
        public static VeinSampleData fromNBT(Level level, CompoundTag nbt) {
            MineralMix mineral = MineralMix.RECIPES.getById(level, new ResourceLocation(nbt.m_128461_("mineral")));
            if (mineral == null) {
                return null;
            }
            return new VeinSampleData(mineral, nbt.m_128459_("percentage"), nbt.m_128459_("saturation"), nbt.m_128451_("depletion"));
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("percentage", this.percentageInTotalSample);
            tag.m_128359_("mineral", this.type.m_6423_().toString());
            tag.m_128405_("depletion", this.depletion);
            tag.m_128347_("saturation", this.saturation);
            return tag;
        }

        public MineralMix getType() {
            return this.type;
        }

        public double getPercentageInTotalSample() {
            return this.percentageInTotalSample;
        }

        public double getSaturation() {
            return this.saturation;
        }

        public int getDepletion() {
            return this.depletion;
        }
    }
}

