/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import malte0811.modelsplitter.math.EpsilonMath;
import malte0811.modelsplitter.math.Plane;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Vertex;
import malte0811.modelsplitter.util.CyclicListWrapper;

public class Polygon<Texture> {
    private static final EpsilonMath EPS_MATH = new EpsilonMath(1.0E-5);
    private final List<Vertex> points;
    private final Texture texture;

    public Polygon(List<Vertex> points, Texture texture) {
        this.points = ImmutableList.copyOf(points);
        this.texture = texture;
    }

    public Polygon(Vertex first, List<Vertex> inner, Vertex last, Texture texture) {
        ArrayList<Vertex> points = new ArrayList<Vertex>();
        if (!EPS_MATH.areSame(first.position(), inner.get(0).position())) {
            points.add(first);
        }
        points.addAll(inner);
        if (!EPS_MATH.areSame(inner.get(inner.size() - 1).position(), last.position())) {
            points.add(last);
        }
        this.points = ImmutableList.copyOf(points);
        this.texture = texture;
    }

    public List<Vertex> getPoints() {
        return this.points;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public Map<EpsilonMath.Sign, Polygon<Texture>> splitAlong(Plane p) {
        EpsilonMath.Sign signHere;
        int firstSignStart;
        ArrayList<EpsilonMath.Sign> signs = new ArrayList<EpsilonMath.Sign>(this.points.size());
        for (Vertex point : this.points) {
            double product = p.normal().dotProduct(point.position()) - p.dotProduct();
            signs.add(EPS_MATH.sign(product));
        }
        EpsilonMath.Sign zeroSign = (EpsilonMath.Sign)((Object)signs.get(0));
        for (firstSignStart = 0; firstSignStart < this.points.size() && (zeroSign == (signHere = (EpsilonMath.Sign)((Object)signs.get(firstSignStart))) || signHere == EpsilonMath.Sign.ZERO); ++firstSignStart) {
        }
        if (firstSignStart >= this.points.size()) {
            return ImmutableMap.of((Object)((Object)zeroSign), (Object)this);
        }
        EpsilonMath.Sign firstSign = (EpsilonMath.Sign)((Object)signs.get(firstSignStart));
        EpsilonMath.Sign otherSign = firstSign.invert();
        if (!signs.contains((Object)otherSign)) {
            return ImmutableMap.of((Object)((Object)firstSign), (Object)this);
        }
        CyclicListWrapper cyclicSigns = new CyclicListWrapper(signs);
        CyclicListWrapper<Vertex> cyclicPoints = new CyclicListWrapper<Vertex>(this.points);
        int otherSignStart = firstSignStart;
        while (cyclicSigns.get(otherSignStart) != otherSign) {
            ++otherSignStart;
        }
        List<Vertex> firstInnerPoints = cyclicPoints.sublist(firstSignStart, otherSignStart);
        List<Vertex> otherInnerPoints = cyclicPoints.sublist(otherSignStart, firstSignStart);
        Vertex firstNewPoint = this.intersect(cyclicPoints.get(firstSignStart - 1), cyclicPoints.get(firstSignStart), p);
        Vertex otherNewPoint = this.intersect(cyclicPoints.get(otherSignStart - 1), cyclicPoints.get(otherSignStart), p);
        return ImmutableMap.of((Object)((Object)firstSign), new Polygon<Texture>(firstNewPoint, firstInnerPoints, otherNewPoint, this.getTexture()), (Object)((Object)otherSign), new Polygon<Texture>(otherNewPoint, otherInnerPoints, firstNewPoint, this.getTexture()));
    }

    private Vertex intersect(Vertex a, Vertex b, Plane p) {
        double productA = a.position().dotProduct(p.normal());
        double productB = b.position().dotProduct(p.normal());
        double lambda = (p.dotProduct() - productB) / (productA - productB);
        return Vertex.interpolate(a, b, lambda);
    }

    public Polygon<Texture> translate(int axis, double amount) {
        ArrayList<Vertex> translatedVertices = new ArrayList<Vertex>(this.points.size());
        for (Vertex v : this.points) {
            translatedVertices.add(v.translate(axis, amount));
        }
        return new Polygon<Texture>(translatedVertices, this.texture);
    }

    public Polygon<Texture> translate(Vec3d offset) {
        ArrayList<Vertex> translatedVertices = new ArrayList<Vertex>(this.points.size());
        for (Vertex v : this.points) {
            translatedVertices.add(v.translate(offset));
        }
        return new Polygon<Texture>(translatedVertices, this.texture);
    }

    public List<Polygon<Texture>> quadify() {
        ArrayList<Polygon<Texture>> quads = new ArrayList<Polygon<Texture>>();
        int secondVertex = 1;
        while (secondVertex + 2 < this.points.size()) {
            quads.add(new Polygon<Texture>((List<Vertex>)ImmutableList.of((Object)this.points.get(0), (Object)this.points.get(secondVertex), (Object)this.points.get(secondVertex + 1), (Object)this.points.get(secondVertex + 2)), this.getTexture()));
            secondVertex += 2;
        }
        if (secondVertex + 1 < this.points.size()) {
            quads.add(new Polygon<Texture>((List<Vertex>)ImmutableList.of((Object)this.points.get(0), (Object)this.points.get(secondVertex), (Object)this.points.get(secondVertex + 1), (Object)this.points.get(secondVertex + 1)), this.getTexture()));
        }
        return quads;
    }

    public Polygon<Texture> recomputeZeroNormals() {
        Vec3d computedNormal = null;
        ArrayList<Vertex> resultVertices = null;
        for (int i = 0; i < this.points.size(); ++i) {
            Vertex point = this.points.get(i);
            if (point.normal().lengthSquared() < 0.001) {
                if (resultVertices == null) {
                    resultVertices = new ArrayList<Vertex>(this.points);
                    Vec3d origin = this.points.get(0).position();
                    Vec3d diff1 = this.points.get(1).position().subtract(origin);
                    Vec3d diff2 = this.points.get(2).position().subtract(origin);
                    computedNormal = diff1.crossProduct(diff2).normalize();
                }
                resultVertices.set(i, new Vertex(point.position(), computedNormal, point.uv()));
                continue;
            }
            if (resultVertices == null) continue;
            resultVertices.set(i, point);
        }
        if (resultVertices == null) {
            return this;
        }
        return new Polygon<Texture>(resultVertices, this.getTexture());
    }
}

