/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.createchunkloading.forge;

import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fml.loading.FMLPaths;
import org.embeddedt.createchunkloading.ChunkLoaderMovementBehaviour;
import org.embeddedt.createchunkloading.CreateChunkloading;

public class ExampleExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static void forceLoadChunk(ServerLevel world, int chunkX, int chunkZ, boolean state, Object entityUUID, boolean shouldLoadSurroundingAsWell) {
        if (entityUUID instanceof UUID) {
            ForgeChunkManager.forceChunk((ServerLevel)world, (String)"createchunkloading", (UUID)((UUID)entityUUID), (int)chunkX, (int)chunkZ, (boolean)state, (boolean)true);
        } else if (entityUUID instanceof BlockPos) {
            ForgeChunkManager.forceChunk((ServerLevel)world, (String)"createchunkloading", (BlockPos)((BlockPos)entityUUID), (int)chunkX, (int)chunkZ, (boolean)state, (boolean)true);
        } else {
            throw new IllegalArgumentException("entityUUID must be UUID or BlockPos");
        }
        if (shouldLoadSurroundingAsWell) {
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX + 1, chunkZ, state, entityUUID, false);
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX + 1, chunkZ + 1, state, entityUUID, false);
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX + 1, chunkZ - 1, state, entityUUID, false);
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX - 1, chunkZ, state, entityUUID, false);
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX - 1, chunkZ + 1, state, entityUUID, false);
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX - 1, chunkZ - 1, state, entityUUID, false);
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX, chunkZ - 1, state, entityUUID, false);
            ExampleExpectPlatformImpl.forceLoadChunk(world, chunkX, chunkZ + 1, state, entityUUID, false);
        }
    }

    public static void registerMovementBehavior() {
        AllMovementBehaviours.registerBehaviour((Block)((Block)CreateChunkloading.CHUNK_LOADER.get()), (MovementBehaviour)new ChunkLoaderMovementBehaviour());
    }
}

