/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.ServerConfig;
import de.maxhenkel.plane.corelib.ClientRegistry;
import de.maxhenkel.plane.corelib.CommonRegistry;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.entity.render.BushPlaneModel;
import de.maxhenkel.plane.entity.render.CargoPlaneModel;
import de.maxhenkel.plane.entity.render.PlaneModel;
import de.maxhenkel.plane.events.CapabilityEvents;
import de.maxhenkel.plane.events.InteractEvents;
import de.maxhenkel.plane.events.KeyEvents;
import de.maxhenkel.plane.events.RenderEvents;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.gui.PlaneScreen;
import de.maxhenkel.plane.integration.waila.PluginPlane;
import de.maxhenkel.plane.item.ModItems;
import de.maxhenkel.plane.loottable.CopyPlaneData;
import de.maxhenkel.plane.net.MessageControlPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import de.maxhenkel.plane.sound.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="plane")
public class Main {
    public static final String MODID = "plane";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static EntityType<EntityPlane> PLANE_ENTITY_TYPE;
    public static EntityType<EntityCargoPlane> CARGO_PLANE_ENTITY_TYPE;
    public static EntityType<EntityBushPlane> BUSH_PLANE_ENTITY_TYPE;
    public static LootItemFunctionType COPY_PLANE_DATA;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static KeyMapping PLANE_KEY;
    public static KeyMapping FORWARD_KEY;
    public static KeyMapping BACK_KEY;
    public static KeyMapping LEFT_KEY;
    public static KeyMapping RIGHT_KEY;
    public static KeyMapping UP_KEY;
    public static KeyMapping DOWN_KEY;
    public static KeyMapping START_KEY;
    public static KeyMapping BRAKE_KEY;
    public static MenuType<ContainerPlane> PLANE_CONTAINER_TYPE;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(MenuType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new InteractEvents());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        COPY_PLANE_DATA = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation(MODID, "copy_plane_data"), (Object)new LootItemFunctionType((Serializer)new CopyPlaneData.Serializer()));
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageControlPlane.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessagePlaneGui.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.ScreenConstructor factory = (container, playerInventory, name) -> new PlaneScreen((ContainerPlane)container, playerInventory, name);
        MenuScreens.m_96206_(PLANE_CONTAINER_TYPE, (MenuScreens.ScreenConstructor)factory);
        PLANE_KEY = ClientRegistry.registerKeyBinding("key.plane", "category.plane", 80);
        FORWARD_KEY = ClientRegistry.registerKeyBinding("key.plane_add_thrust", "category.plane", 73);
        BACK_KEY = ClientRegistry.registerKeyBinding("key.plane_remove_thrust", "category.plane", 75);
        LEFT_KEY = ClientRegistry.registerKeyBinding("key.plane_left", "category.plane", 65);
        RIGHT_KEY = ClientRegistry.registerKeyBinding("key.plane_right", "category.plane", 68);
        UP_KEY = ClientRegistry.registerKeyBinding("key.plane_up", "category.plane", 83);
        DOWN_KEY = ClientRegistry.registerKeyBinding("key.plane_down", "category.plane", 87);
        START_KEY = ClientRegistry.registerKeyBinding("key.plane_start", "category.plane", 82);
        BRAKE_KEY = ClientRegistry.registerKeyBinding("key.plane_brake", "category.plane", 66);
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        try {
            Class.forName("mcp.mobius.waila.api.event.WailaRenderEvent");
            MinecraftForge.EVENT_BUS.register((Object)new PluginPlane());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        EntityRenderers.m_174036_(PLANE_ENTITY_TYPE, manager -> new PlaneModel(manager));
        EntityRenderers.m_174036_(CARGO_PLANE_ENTITY_TYPE, manager -> new CargoPlaneModel(manager));
        EntityRenderers.m_174036_(BUSH_PLANE_ENTITY_TYPE, manager -> new BushPlaneModel(manager));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.CARGO_PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.BUSH_PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModItems.WRENCH, ModItems.PLANE_WHEEL, ModItems.PLANE_ENGINE, ModItems.DIAMOND_REINFORCED_IRON});
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModSounds.getAll().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        PLANE_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, MODID, MobCategory.MISC, EntityPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityPlane((Level)world)));
        event.getRegistry().register(PLANE_ENTITY_TYPE);
        CARGO_PLANE_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, "cargo_plane", MobCategory.MISC, EntityCargoPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityCargoPlane((Level)world)));
        event.getRegistry().register(CARGO_PLANE_ENTITY_TYPE);
        BUSH_PLANE_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, "bush_plane", MobCategory.MISC, EntityBushPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityBushPlane((Level)world)));
        event.getRegistry().register(BUSH_PLANE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        PLANE_CONTAINER_TYPE = new MenuType((MenuType.MenuSupplier)((IContainerFactory)(windowId, inv, data) -> {
            EntityPlaneSoundBase plane = Main.getPlaneByUUID(inv.f_35978_, data.m_130259_());
            if (plane == null) {
                return null;
            }
            return new ContainerPlane(windowId, plane, inv);
        }));
        PLANE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(PLANE_CONTAINER_TYPE);
    }

    @Nullable
    public static EntityPlaneSoundBase getPlaneByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.f_19853_.m_6443_(EntityPlaneSoundBase.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_142081_().equals(uuid)).stream().findAny().orElse(null);
    }
}

