/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.plane.corelib.client.obj.OBJModelOptions;
import de.maxhenkel.plane.corelib.math.Rotation;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class BushPlaneModel
extends AbstractPlaneModel<EntityBushPlane> {
    private static final List<OBJModelInstance<EntityBushPlane>> MODELS = Arrays.asList(new OBJModelInstance<EntityBushPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions<EntityBushPlane>(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vector3d(-0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityBushPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions<EntityBushPlane>(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vector3d(0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityBushPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/propeller.obj")), new OBJModelOptions<EntityBushPlane>(new ResourceLocation("textures/block/spruce_planks.png"), new Vector3d(0.0, 1.0, -1.84375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-plane.getPropellerRotation(partialTicks)));
    })));
    private static final List<OBJModelInstance<EntityBushPlane>> OAK_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/oak_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> DARK_OAK_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/dark_oak_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> BIRCH_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/birch_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> JUNGLE_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/jungle_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> ACACIA_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/acacia_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> SPRUCE_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/spruce_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> WARPED_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/warped_planks.png"));
    private static final List<OBJModelInstance<EntityBushPlane>> CRIMSON_MODEL = BushPlaneModel.getPlaneModel(new ResourceLocation("textures/block/crimson_planks.png"));

    public BushPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityBushPlane plane, PoseStack matrixStack, boolean left) {
        if (left) {
            matrixStack.m_85837_(0.500625, -1.25, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        } else {
            matrixStack.m_85837_(-0.500625, -1.25, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        }
    }

    @Override
    public List<OBJModelInstance<EntityBushPlane>> getModels(EntityBushPlane entity) {
        return BushPlaneModel.getModelFromType(entity);
    }

    private static List<OBJModelInstance<EntityBushPlane>> getModelFromType(EntityBushPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: {
                return ACACIA_MODEL;
            }
            case WARPED: {
                return WARPED_MODEL;
            }
            case CRIMSON: 
        }
        return CRIMSON_MODEL;
    }

    private static List<OBJModelInstance<EntityBushPlane>> getPlaneModel(ResourceLocation texture) {
        ArrayList<OBJModelInstance<EntityBushPlane>> models = new ArrayList<OBJModelInstance<EntityBushPlane>>(MODELS);
        models.add(new OBJModelInstance<EntityBushPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/bush_plane.obj")), new OBJModelOptions<EntityBushPlane>(texture, new Vector3d(0.0, 0.5, 0.0), new Rotation(180.0f, Vector3f.f_122225_), (plane, matrixStack, partialTicks) -> {})));
        return models;
    }
}

