/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.CompactingRecipes;
import com.github.talrey.createdeco.Config;
import com.github.talrey.createdeco.ConfigCondition;
import com.github.talrey.createdeco.MovementCheckHandler;
import com.github.talrey.createdeco.PolishingRecipes;
import com.github.talrey.createdeco.PressingRecipes;
import com.github.talrey.createdeco.ProcessingRecipeWrapper;
import com.github.talrey.createdeco.Registration;
import com.github.talrey.createdeco.SplashingRecipes;
import com.tterrag.registrate.Registrate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="createdeco")
public class CreateDecoMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "createdeco";
    public static Registrate createDecoRegistrar;
    private static Registration registration;
    private static ProcessingRecipeWrapper SPLASHING;
    private static ProcessingRecipeWrapper PRESSING;
    private static ProcessingRecipeWrapper POLISHING;
    private static ProcessingRecipeWrapper COMPACTING;

    public CreateDecoMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONF);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONF);
        MinecraftForge.EVENT_BUS.register((Object)this);
        createDecoRegistrar = Registrate.create((String)MODID);
        registration = new Registration();
        Registration.registerItems(createDecoRegistrar);
        Registration.registerBlocks(createDecoRegistrar);
        MovementCheckHandler.register();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRecipeSerializerRegistry(RegistryEvent.Register<RecipeSerializer<?>> event) {
            CraftingHelper.register((IConditionSerializer)ConfigCondition.Serializer.INSTANCE);
        }

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }

        @SubscribeEvent
        public static void gatherData(GatherDataEvent gde) {
            DataGenerator gen = gde.getGenerator();
            SPLASHING = new SplashingRecipes(gen);
            gen.m_123914_((DataProvider)SPLASHING);
            PRESSING = new PressingRecipes(gen);
            gen.m_123914_((DataProvider)PRESSING);
            POLISHING = new PolishingRecipes(gen);
            gen.m_123914_((DataProvider)POLISHING);
            COMPACTING = new CompactingRecipes(gen);
            gen.m_123914_((DataProvider)COMPACTING);
        }
    }
}

