/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DecalBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape NORTH = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    private static final VoxelShape SOUTH = Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape EAST = Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape WEST = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);

    public DecalBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canSupportDecal(LevelAccessor world, BlockPos pos, Direction side) {
        return DecalBlock.canSupportDecal(world, world.m_8055_(pos), pos, side);
    }

    private static boolean canSupportDecal(LevelAccessor world, BlockState state, BlockPos pos, Direction side) {
        return state.m_60659_((BlockGetter)world, pos, side, SupportType.CENTER);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction face = ctx.m_43719_();
        if (face.m_122434_() == Direction.Axis.Y) {
            face = ctx.m_8125_().m_122424_();
        }
        BlockPos neighbor = ctx.m_8083_().m_141952_(face.m_122424_().m_122436_());
        if (!DecalBlock.canSupportDecal((LevelAccessor)ctx.m_43725_(), neighbor, face)) {
            return null;
        }
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face.m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!dir.equals((Object)state.m_61143_((Property)BlockStateProperties.f_61374_))) {
            return state;
        }
        return neighbor.m_60659_((BlockGetter)world, neighborPos, ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_(), SupportType.CENTER) ? super.m_7417_(state, dir, neighbor, world, pos, neighborPos) : Blocks.f_50016_.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }
}

