/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator.aggregator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class TranslationsAggregator
implements ResourceAggregator<Map<String, String>, Map<String, String>> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final TranslationsAggregator INSTANCE = new TranslationsAggregator();

    private TranslationsAggregator() {
    }

    @Override
    public Map<String, String> initialData() {
        return new LinkedHashMap<String, String>();
    }

    @Override
    public Map<String, String> combine(Map<String, String> data, Map<String, String> newData) {
        newData.forEach((key, translation) -> {
            String oldValue = data.put((String)key, (String)translation);
            if (oldValue != null && !oldValue.equals(translation)) {
                throw new IllegalArgumentException("Conflicting translations for key '" + key + "'!");
            }
        });
        return data;
    }

    @Override
    public void write(OutputStream stream, Map<String, String> data) throws IOException {
        JsonObject json = new JsonObject();
        data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
    }
}

