/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.NonNullConsumer;

public abstract class TileComputerBase
extends TileGeneric
implements IComputerTile,
Nameable,
MenuProvider {
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private int instanceID = -1;
    private int computerID = -1;
    protected String label = null;
    private boolean on = false;
    boolean startOn = false;
    private boolean fresh = false;
    private int invalidSides = 0;
    private final NonNullConsumer<Object>[] invalidate;
    private LockCode lockCode = LockCode.f_19102_;
    private final ComputerFamily family;

    public TileComputerBase(BlockEntityType<? extends TileGeneric> type, BlockPos pos, BlockState state, ComputerFamily family) {
        super(type, pos, state);
        this.family = family;
        this.invalidate = new NonNullConsumer[6];
        NonNullConsumer[] invalidate = this.invalidate;
        for (Direction direction : Direction.values()) {
            int mask = 1 << direction.ordinal();
            invalidate[direction.ordinal()] = o -> this.invalidSides |= mask;
        }
    }

    protected void unload() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.close();
        }
        this.instanceID = -1;
    }

    @Override
    public void destroy() {
        this.unload();
        for (Direction dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.m_58904_(), this.m_58899_(), dir);
        }
    }

    public void onChunkUnloaded() {
        this.unload();
    }

    public void m_7651_() {
        this.unload();
        super.m_7651_();
    }

    protected boolean canNameWithTag(Player player) {
        return false;
    }

    @Override
    public boolean isUsable(Player player) {
        return super.isUsable(player) && BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.lockCode, (Component)this.m_5446_());
    }

    @Override
    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack currentItem = player.m_21120_(hand);
        if (!currentItem.m_41619_() && currentItem.m_41720_() == Items.f_42656_ && this.canNameWithTag(player) && currentItem.m_41788_()) {
            if (!this.m_58904_().f_46443_) {
                this.setLabel(currentItem.m_41786_().getString());
                currentItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_()) {
            if (!this.m_58904_().f_46443_ && this.isUsable(player)) {
                ServerComputer computer = this.createServerComputer();
                computer.turnOn();
                ItemStack stack = this.m_58900_().m_60734_() instanceof BlockComputerBase ? ((BlockComputerBase)this.m_58900_().m_60734_()).getItem(this) : ItemStack.f_41583_;
                new ComputerContainerData(computer, stack).open(player, this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        this.updateInputAt(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        this.updateInputAt(neighbour);
    }

    protected void serverTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        ServerComputer computer = this.createServerComputer();
        if (this.invalidSides != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(computer, direction);
            }
        }
        if (this.startOn || this.fresh && this.on) {
            computer.turnOn();
            this.startOn = false;
        }
        computer.keepAlive();
        this.fresh = false;
        this.computerID = computer.getID();
        this.label = computer.getLabel();
        this.on = computer.isOn();
        this.updateBlockState(computer.getState());
        if (computer.hasOutputChanged()) {
            this.updateOutput();
        }
    }

    protected abstract void updateBlockState(ComputerState var1);

    public void m_183515_(@Nonnull CompoundTag nbt) {
        if (this.computerID >= 0) {
            nbt.m_128405_(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.m_128359_(NBT_LABEL, this.label);
        }
        nbt.m_128379_(NBT_ON, this.on);
        this.lockCode.m_19109_(nbt);
        super.m_183515_(nbt);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.computerID = nbt.m_128441_(NBT_ID) ? nbt.m_128451_(NBT_ID) : -1;
        this.label = nbt.m_128441_(NBT_LABEL) ? nbt.m_128461_(NBT_LABEL) : null;
        this.on = this.startOn = nbt.m_128471_(NBT_ON);
        this.lockCode = LockCode.m_19111_((CompoundTag)nbt);
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected abstract Direction getDirection();

    protected ComputerSide remapToLocalSide(Direction globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    private void updateRedstoneInput(@Nonnull ServerComputer computer, Direction dir, BlockPos targetPos) {
        Direction offsetSide = dir.m_122424_();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneInput(this.f_58857_, targetPos, dir));
        computer.setBundledRedstoneInput(localDir, BundledRedstone.getOutput(this.m_58904_(), targetPos, offsetSide));
    }

    private void refreshPeripheral(@Nonnull ServerComputer computer, Direction dir) {
        this.invalidSides &= ~(1 << dir.ordinal());
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (this.isPeripheralBlockedOnSide(localDir)) {
            return;
        }
        Direction offsetSide = dir.m_122424_();
        IPeripheral peripheral = Peripherals.getPeripheral(this.m_58904_(), this.m_58899_().m_142300_(dir), offsetSide, this.invalidate[dir.ordinal()]);
        computer.setPeripheral(localDir, peripheral);
    }

    public void updateInputsImmediately() {
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateInputsImmediately(computer);
        }
    }

    private void updateInputsImmediately(@Nonnull ServerComputer computer) {
        BlockPos pos = this.m_58899_();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.m_142300_(dir));
            this.refreshPeripheral(computer, dir);
        }
    }

    private void updateInputAt(@Nonnull BlockPos neighbour) {
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = this.m_58899_().m_142300_(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(computer, dir, offset);
            this.invalidSides |= 1 << dir.ordinal();
            return;
        }
        BlockPos pos = this.m_58899_();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.m_142300_(dir));
        }
        this.invalidSides = 63;
    }

    public void updateOutput() {
        this.updateBlock();
        for (Direction dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.m_58904_(), this.m_58899_(), dir);
        }
    }

    protected abstract ServerComputer createComputer(int var1);

    @Override
    public final int getComputerID() {
        return this.computerID;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setComputerID(int id) {
        if (this.m_58904_().f_46443_ || this.computerID == id) {
            return;
        }
        this.computerID = id;
        this.m_6596_();
    }

    @Override
    public final void setLabel(String label) {
        if (this.m_58904_().f_46443_ || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        this.m_6596_();
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Nonnull
    public final ServerComputer createServerComputer() {
        if (this.m_58904_().f_46443_) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        ServerComputer computer = ServerContext.get(this.m_58904_().m_142572_()).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(this.f_58857_, "computer");
                this.updateBlock();
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    @Nullable
    public ServerComputer getServerComputer() {
        return this.m_58904_().f_46443_ ? null : ServerContext.get(this.m_58904_().m_142572_()).registry().get(this.instanceID);
    }

    @Nonnull
    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.label != null) {
            nbt.m_128359_(NBT_LABEL, this.label);
        }
        if (this.computerID >= 0) {
            nbt.m_128405_(NBT_ID, this.computerID);
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag nbt) {
        this.label = nbt.m_128441_(NBT_LABEL) ? nbt.m_128461_(NBT_LABEL) : null;
        this.computerID = nbt.m_128441_(NBT_ID) ? nbt.m_128451_(NBT_ID) : -1;
    }

    protected void transferStateFrom(TileComputerBase copy) {
        if (copy.computerID != this.computerID || copy.instanceID != this.instanceID) {
            this.unload();
            this.instanceID = copy.instanceID;
            this.computerID = copy.computerID;
            this.label = copy.label;
            this.on = copy.on;
            this.startOn = copy.startOn;
            this.lockCode = copy.lockCode;
            this.updateBlock();
        }
        copy.instanceID = -1;
    }

    @Nonnull
    public Component m_7755_() {
        return this.m_8077_() ? new TextComponent(this.label) : new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    public boolean m_8077_() {
        return !Strings.isNullOrEmpty((String)this.label);
    }

    @Nullable
    public Component m_7770_() {
        return this.m_8077_() ? new TextComponent(this.label) : null;
    }

    @Nonnull
    public Component m_5446_() {
        return super.m_5446_();
    }
}

