/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static boolean areItemsEqual(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return a == b || ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemsStackable(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return a == b || ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b);
    }

    @Nullable
    public static IItemHandler getInventory(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        Entity entity;
        Direction dir;
        Vec3 vecDir;
        BlockState block;
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            LazyOptional itemHandler = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (itemHandler.isPresent()) {
                return (IItemHandler)itemHandler.orElseThrow(NullPointerException::new);
            }
            if (tileEntity instanceof WorldlyContainer) {
                return new SidedInvWrapper((WorldlyContainer)tileEntity, side);
            }
            if (tileEntity instanceof Container) {
                return new InvWrapper((Container)tileEntity);
            }
        }
        if ((block = world.m_8055_(pos)).m_60734_() instanceof WorldlyContainerHolder) {
            WorldlyContainer inventory = ((WorldlyContainerHolder)block.m_60734_()).m_5840_(block, (LevelAccessor)world, pos);
            return new SidedInvWrapper(inventory, side);
        }
        Vec3 vecStart = new Vec3((double)pos.m_123341_() + 0.5 + 0.6 * (double)side.m_122429_(), (double)pos.m_123342_() + 0.5 + 0.6 * (double)side.m_122430_(), (double)pos.m_123343_() + 0.5 + 0.6 * (double)side.m_122431_());
        Pair<Entity, Vec3> hit = WorldUtil.rayTraceEntities(world, vecStart, vecDir = new Vec3((double)(dir = side.m_122424_()).m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_()), 1.1);
        if (hit != null && (entity = (Entity)hit.getKey()) instanceof Container) {
            return new InvWrapper((Container)entity);
        }
        return null;
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack itemstack, IItemHandler inventory, int begin) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.getSlots(), begin);
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack itemstack, IItemHandler inventory) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.getSlots(), 0);
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack stack, IItemHandler inventory, int start, int range, int begin) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack remainder = stack.m_41777_();
        for (int i = 0; i < range; ++i) {
            int slot = start + (i + begin - start) % range;
            if (remainder.m_41619_()) break;
            remainder = inventory.insertItem(slot, remainder, false);
        }
        return InventoryUtil.areItemsEqual(stack, remainder) ? stack : remainder;
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory, int begin) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.getSlots(), begin);
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.getSlots(), 0);
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory, int start, int range, int begin) {
        ItemStack partialStack = ItemStack.f_41583_;
        for (int i = 0; i < range; ++i) {
            ItemStack extracted;
            int slot = start + (i + begin - start) % range;
            if (count <= 0) break;
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.m_41619_() || !partialStack.m_41619_() && !InventoryUtil.areItemsStackable(stack, partialStack) || (extracted = inventory.extractItem(slot, count, false)).m_41619_()) continue;
            if (partialStack.m_41619_()) {
                partialStack = extracted;
                count = Math.min(count, extracted.m_41741_());
            } else {
                partialStack.m_41769_(extracted.m_41613_());
            }
            count -= extracted.m_41613_();
        }
        return partialStack;
    }
}

