/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingWithTypesBucketable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityFlyingFish
extends EntityWaterMobPathingWithTypesBucketable {
    public EntityFlyingFish(EntityType<? extends EntityFlyingFish> entityType, Level worldIn) {
        super((EntityType<? extends EntityWaterMobPathingWithTypesBucketable>)entityType, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, WaterAnimal.class, 10.0f));
        this.f_21345_.m_25352_(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SurfaceOnAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FlyingFishFlyGoal(this, 5));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 1));
    }

    @Override
    public void m_8107_() {
        if (!this.m_20069_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    @Override
    public EntityTypeContainer<? extends EntityFlyingFish> getContainer() {
        return ModEntities.FLYING_FISH;
    }

    @Override
    public EntityTypeContainerContainable<?, ?> getContainableContainer() {
        return ModEntities.FLYING_FISH;
    }

    public static class SurfaceOnAttackGoal
    extends Goal {
        private final EntityFlyingFish fish;
        private int targetY = 0;
        private boolean fail = false;

        public SurfaceOnAttackGoal(EntityFlyingFish fish) {
            this.fish = fish;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            int i = this.getTopWaterBlock();
            return this.fish.m_21188_() != null && i != -1 && this.fish.m_20183_().m_123342_() < i;
        }

        public boolean m_8045_() {
            return !this.fail && this.fish.m_20183_().m_123342_() != this.targetY;
        }

        public void m_8056_() {
            this.fail = false;
            this.targetY = this.getTopWaterBlock();
        }

        public void m_8037_() {
            if (!this.fish.m_21573_().m_26519_((double)this.fish.m_20183_().m_123341_(), (double)this.targetY, (double)this.fish.m_20183_().m_123343_(), 1.0)) {
                this.fail = true;
            }
        }

        public void m_8041_() {
            this.fail = false;
        }

        private int getTopWaterBlock() {
            if (this.fish.m_20069_()) {
                Level world = this.fish.f_19853_;
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.fish.m_20183_().m_123341_(), this.fish.m_20183_().m_123342_(), this.fish.m_20183_().m_123343_());
                for (int i = this.fish.m_20183_().m_123342_(); i < this.fish.f_19853_.m_141928_(); ++i) {
                    pos.m_142448_(i);
                    if (!world.m_6425_((BlockPos)pos).m_205070_(FluidTags.f_13131_) || !world.m_46859_(pos.m_7494_())) continue;
                    return i;
                }
            }
            this.fail = true;
            return -1;
        }
    }

    public static class FlyingFishFlyGoal
    extends JumpGoal {
        private final EntityFlyingFish fish;
        private final int chance;
        private boolean inWater;
        private BlockPos start;
        private int ticks = 0;
        private int scale;

        public FlyingFishFlyGoal(EntityFlyingFish fish, int chance) {
            this.fish = fish;
            this.chance = chance;
        }

        public boolean m_8036_() {
            boolean revenge;
            boolean bl = revenge = this.fish.m_21188_() != null && this.fish.m_21188_().m_20270_((Entity)this.fish) < 10.0f;
            if (revenge || this.fish.m_217043_().m_188503_(this.chance) == 0) {
                Direction direction = this.fish.m_6374_();
                int dx = direction.m_122429_();
                int dz = direction.m_122431_();
                if (revenge) {
                    LivingEntity attacker = this.fish.m_21188_();
                    Vec3 vec = attacker.m_20182_().m_82546_(this.fish.m_20182_()).m_82541_();
                    dx = (int)vec.f_82479_;
                    dz = (int)vec.f_82481_;
                }
                for (int tempScale = this.scale = this.fish.m_217043_().m_188503_(4) + (revenge ? 7 : 5); tempScale >= 1; --tempScale) {
                    if (this.canJumpTo(this.fish.m_20183_(), dx, dz, tempScale) && this.isAirAbove(this.fish.m_20183_(), dx, dz, tempScale)) continue;
                    return false;
                }
                this.start = this.fish.m_20183_();
                return true;
            }
            return false;
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.m_7918_(dx * scale, 0, dz * scale);
            return this.fish.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.fish.f_19853_.m_8055_(blockpos).m_60767_().m_76334_();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.fish.f_19853_.m_46859_(pos.m_7918_(dx * scale, 1, dz * scale)) && this.fish.f_19853_.m_46859_(pos.m_7918_(dx * scale, 2, dz * scale));
        }

        public boolean m_8045_() {
            return this.ticks < 200 && this.fish.m_21188_() != null ? this.fish.m_21188_().m_20270_((Entity)this.fish) > 10.0f : this.fish.m_20182_().m_82554_(new Vec3((double)this.start.m_123341_() + 0.5, (double)this.start.m_123342_(), (double)this.start.m_123343_() + 0.5)) < (double)this.scale;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8041_() {
            this.fish.m_146926_(0.0f);
            this.ticks = 0;
        }

        public void m_8037_() {
            boolean lastInWater = this.inWater;
            if (!lastInWater) {
                this.inWater = this.fish.f_19853_.m_6425_(this.fish.m_20183_()).m_205070_(FluidTags.f_13131_);
            }
            if (this.inWater && !lastInWater) {
                this.fish.m_5496_(SoundEvents.f_11805_, 1.0f, 1.0f);
            }
            Vec3 vec3d = this.fish.m_20184_();
            if (vec3d.f_82480_ * vec3d.f_82480_ < (double)0.03f && this.fish.m_146909_() != 0.0f) {
                this.fish.m_146926_(Mth.m_14201_((float)this.fish.m_146909_(), (float)0.0f, (float)0.2f));
            } else {
                double d0 = Math.sqrt(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_);
                double d1 = Math.signum(-vec3d.f_82480_) * Math.acos(d0 / vec3d.m_82553_()) * 57.2957763671875;
                this.fish.m_146926_((float)d1);
            }
            Direction direction = this.fish.m_6374_();
            this.fish.m_20256_(this.fish.m_20184_().m_82520_((double)direction.m_122429_() * 0.03, 0.04, (double)direction.m_122431_() * 0.03));
            this.fish.m_21573_().m_26573_();
            ++this.ticks;
        }
    }
}

