/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithSelectiveTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntitySquirrel
extends EntityAnimalWithSelectiveTypes {
    protected static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(EntitySquirrel.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final String[] ALL_TYPES = new String[]{"gray", "red", "albino"};
    private int climbTimeWithoutLog = 0;

    public EntitySquirrel(EntityType<? extends EntitySquirrel> entityType, Level worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)entityType, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 0.72));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 0.5));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 0.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_}), false));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 10.0f, 0.5, 0.7));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            boolean nearLog = false;
            for (Direction facing : Direction.values()) {
                BlockPos pos = this.m_20183_().m_121945_(facing);
                Block block = this.f_19853_.m_8055_(pos).m_60734_();
                if (block != Blocks.f_50003_ && block != Blocks.f_50001_ && block != Blocks.f_50004_ && block != Blocks.f_50002_ && block != Blocks.f_49999_ && block != Blocks.f_50000_) continue;
                nearLog = true;
            }
            this.setBesideClimbableBlock(this.f_19862_ && nearLog || this.f_19862_ && this.climbTimeWithoutLog < 15);
            if (this.f_19862_ && !nearLog) {
                ++this.climbTimeWithoutLog;
            } else if (this.climbTimeWithoutLog > 0 || this.f_19862_) {
                this.climbTimeWithoutLog = 0;
            }
        }
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        EntitySquirrel squirrel = (EntitySquirrel)this.getContainer().getEntityType().m_20615_((Level)world);
        if (ageable instanceof EntitySquirrel) {
            EntitySquirrel other = (EntitySquirrel)ageable;
            if ((this.isAlbino() || other.isAlbino()) && !this.getVariantNameOrEmpty().equals(other.getVariantNameOrEmpty())) {
                squirrel.setType(this.isAlbino() ? (IVariant)other.getVariant().get() : (IVariant)this.getVariant().get());
            } else {
                squirrel.setType(this.f_19796_.m_188499_() ? (IVariant)this.getVariant().get() : (IVariant)other.getVariant().get());
            }
        }
        return squirrel;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42404_ || stack.m_41720_() == Items.f_42733_ || stack.m_41720_() == Items.f_42578_ || stack.m_41720_() == Items.f_42577_;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    protected EntitySquirrel getBaseChild() {
        return null;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        return EntityUtil.childChance((AgeableMob)this, reason, super.m_6518_(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (types.contains(BiomeTypes.FOREST) && !types.contains(BiomeTypes.CONIFEROUS)) {
            return new String[]{"gray", "albino"};
        }
        if (types.contains(BiomeTypes.CONIFEROUS) && !types.contains(BiomeTypes.SNOWY)) {
            return new String[]{"red"};
        }
        return ALL_TYPES;
    }

    @Override
    public EntityTypeContainer<EntitySquirrel> getContainer() {
        return ModEntities.SQUIRREL;
    }

    protected boolean isAlbino() {
        return "albino".equals(this.getVariantNameOrEmpty());
    }

    public static boolean canSquirrelSpawn(EntityType<EntitySquirrel> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        BlockState below = world.m_8055_(pos.m_7495_());
        return Mob.m_217057_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand) || below.m_204336_(BlockTags.f_13035_) || below.m_204336_(BlockTags.f_13106_);
    }
}

