/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.compiler;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.Lua;
import cc.tweaked.internal.cobalt.LuaDouble;
import cc.tweaked.internal.cobalt.LuaInteger;
import cc.tweaked.internal.cobalt.LuaNumber;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.OperationHelper;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.compiler.BinOpr;
import cc.tweaked.internal.cobalt.compiler.CompileException;
import cc.tweaked.internal.cobalt.compiler.ExpKind;
import cc.tweaked.internal.cobalt.compiler.IntPtr;
import cc.tweaked.internal.cobalt.compiler.Lex;
import cc.tweaked.internal.cobalt.compiler.LuaC;
import cc.tweaked.internal.cobalt.compiler.Parser;
import cc.tweaked.internal.cobalt.compiler.UnOpr;
import cc.tweaked.internal.cobalt.function.LocalVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FuncState {
    final FuncState prev;
    final Lex lexer;
    final List<LuaValue> constants = new ArrayList<LuaValue>(0);
    private final Map<LuaValue, Integer> constantLookup = new HashMap<LuaValue, Integer>();
    final List<LocalVariable> locals = new ArrayList<LocalVariable>(0);
    final List<Prototype> children = new ArrayList<Prototype>(0);
    final List<UpvalueDesc> upvalues = new ArrayList<UpvalueDesc>(0);
    int pc;
    int[] code;
    private int[] lineInfo;
    private int[] columnInfo;
    int lineDefined;
    int lastLineDefined;
    int numParams;
    int varargFlags;
    int maxStackSize = 2;
    BlockCnt block;
    int lastTarget = -1;
    final IntPtr jpc = new IntPtr(-1);
    int freeReg;
    short activeVariableCount;
    short[] activeVariables = new short[200];

    FuncState(Lex lexer, FuncState prev) {
        this.lexer = lexer;
        this.prev = prev;
    }

    Prototype toPrototype() {
        int i = 0;
        LuaString[] upvalueNames = new LuaString[this.upvalues.size()];
        for (UpvalueDesc upvalue : this.upvalues) {
            upvalueNames[i++] = upvalue.name;
        }
        return new Prototype(this.lexer.source, this.constants.toArray(new LuaValue[0]), LuaC.realloc(this.code, this.pc), this.children.toArray(new Prototype[0]), this.numParams, this.varargFlags, this.maxStackSize, this.upvalues.size(), this.lineDefined, this.lastLineDefined, LuaC.realloc(this.lineInfo, this.pc), LuaC.realloc(this.columnInfo, this.pc), this.locals.toArray(new LocalVariable[0]), upvalueNames);
    }

    int codeAsBxAt(int o, int A, int sBx, long position) throws CompileException {
        return this.codeABxAt(o, A, sBx + 131071, position);
    }

    int codeAsBx(int o, int A, int sBx) throws CompileException {
        return this.codeABx(o, A, sBx + 131071);
    }

    void setMultiRet(Parser.ExpDesc e) throws CompileException {
        this.setReturns(e, -1);
    }

    LocalVariable getLocal(int i) {
        return this.locals.get(this.activeVariables[i]);
    }

    void nil(int from, int n) throws CompileException {
        if (this.pc > this.lastTarget) {
            if (this.pc == 0) {
                if (from >= this.activeVariableCount) {
                    return;
                }
            } else {
                int previous = this.code[this.pc - 1];
                if (Lua.GET_OPCODE(previous) == 3) {
                    int pfrom = Lua.GETARG_A(previous);
                    int pto = Lua.GETARG_B(previous);
                    if (pfrom <= from && from <= pto + 1) {
                        if (from + n - 1 > pto) {
                            this.code[this.pc - 1] = LuaC.SETARG_B(previous, from + n - 1);
                        }
                        return;
                    }
                }
            }
        }
        this.codeABC(3, from, from + n - 1, 0);
    }

    int jump() throws CompileException {
        int jpc = this.jpc.value;
        this.jpc.value = -1;
        IntPtr j = new IntPtr(this.codeAsBx(22, 0, -1));
        this.concat(j, jpc);
        return j.value;
    }

    void ret(int first, int nret) throws CompileException {
        this.codeABC(30, first, nret + 1, 0);
    }

    private int condJump(int op, int A, int B, int C, long position) throws CompileException {
        this.codeABCAt(op, A, B, C, position);
        return this.jump();
    }

    private void fixJump(int pc, int dest) throws CompileException {
        int offset = dest - (pc + 1);
        assert (dest != -1);
        if (Math.abs(offset) > 131071) {
            throw this.lexer.syntaxError("control structure too long");
        }
        this.code[pc] = LuaC.SETARG_sBx(this.code[pc], offset);
    }

    int getLabel() {
        this.lastTarget = this.pc;
        return this.pc;
    }

    private int getJump(int pc) {
        int offset = Lua.GETARG_sBx(this.code[pc]);
        if (offset == -1) {
            return -1;
        }
        return pc + 1 + offset;
    }

    private int getJumpControl(int pc) {
        if (pc >= 1 && Lua.testTMode(Lua.GET_OPCODE(this.code[pc - 1]))) {
            return pc - 1;
        }
        return pc;
    }

    private boolean needValue(int list) {
        while (list != -1) {
            if (Lua.GET_OPCODE(this.code[this.getJumpControl(list)]) != 27) {
                return true;
            }
            list = this.getJump(list);
        }
        return false;
    }

    private boolean patchTestReg(int node, int reg) {
        int jumpControlPc = this.getJumpControl(node);
        int op = this.code[jumpControlPc];
        if (Lua.GET_OPCODE(op) != 27) {
            return false;
        }
        this.code[jumpControlPc] = reg != 255 && reg != Lua.GETARG_B(op) ? LuaC.SETARG_A(op, reg) : LuaC.CREATE_ABC(26, Lua.GETARG_B(op), 0, Lua.GETARG_C(op));
        return true;
    }

    private void removeValues(int list) {
        while (list != -1) {
            this.patchTestReg(list, 255);
            list = this.getJump(list);
        }
    }

    private void patchListAux(int list, int vtarget, int reg, int dtarget) throws CompileException {
        while (list != -1) {
            int next = this.getJump(list);
            if (this.patchTestReg(list, reg)) {
                this.fixJump(list, vtarget);
            } else {
                this.fixJump(list, dtarget);
            }
            list = next;
        }
    }

    private void dischargeJumpPc() throws CompileException {
        this.patchListAux(this.jpc.value, this.pc, 255, this.pc);
        this.jpc.value = -1;
    }

    void patchList(int list, int target) throws CompileException {
        if (target == this.pc) {
            this.patchToHere(list);
        } else {
            LuaC._assert(target < this.pc);
            this.patchListAux(list, target, 255, target);
        }
    }

    void patchToHere(int list) throws CompileException {
        this.getLabel();
        this.concat(this.jpc, list);
    }

    void concat(IntPtr l1, int l2) throws CompileException {
        if (l2 == -1) {
            return;
        }
        if (l1.value == -1) {
            l1.value = l2;
        } else {
            int next;
            int list = l1.value;
            while ((next = this.getJump(list)) != -1) {
                list = next;
            }
            this.fixJump(list, l2);
        }
    }

    void checkStack(int n) throws CompileException {
        int newStack = this.freeReg + n;
        if (newStack > this.maxStackSize) {
            if (newStack >= 250) {
                throw this.lexer.syntaxError("function or expression too complex");
            }
            this.maxStackSize = newStack;
        }
    }

    void reserveRegs(int n) throws CompileException {
        this.checkStack(n);
        this.freeReg += n;
    }

    private void freeReg(int reg) throws CompileException {
        if (!Lua.ISK(reg) && reg >= this.activeVariableCount) {
            --this.freeReg;
            LuaC._assert(reg == this.freeReg);
        }
    }

    private void freeExp(Parser.ExpDesc e) throws CompileException {
        if (e.kind == ExpKind.VNONRELOC) {
            this.freeReg(e.info);
        }
    }

    private int addConstant(LuaValue v) {
        Integer existing = this.constantLookup.get(v);
        if (existing != null) {
            return existing;
        }
        int idx = this.constants.size();
        this.constantLookup.put(v, idx);
        this.constants.add(v);
        return idx;
    }

    int stringK(LuaString s) {
        return this.addConstant(s);
    }

    int numberK(LuaNumber r) {
        int i;
        double d;
        if (r instanceof LuaDouble && (d = r.toDouble()) == (double)(i = (int)d)) {
            r = LuaInteger.valueOf(i);
        }
        return this.addConstant(r);
    }

    private int boolK(boolean b) {
        return this.addConstant(b ? Constants.TRUE : Constants.FALSE);
    }

    private int nilK() {
        return this.addConstant(Constants.NIL);
    }

    void setReturns(Parser.ExpDesc e, int nresults) throws CompileException {
        if (e.kind == ExpKind.VCALL) {
            this.code[e.info] = LuaC.SETARG_C(this.code[e.info], nresults + 1);
        } else if (e.kind == ExpKind.VVARARG) {
            int op = LuaC.SETARG_B(this.code[e.info], nresults + 1);
            this.code[e.info] = LuaC.SETARG_A(op, this.freeReg);
            this.reserveRegs(1);
        }
    }

    void setOneRet(Parser.ExpDesc e) {
        if (e.kind == ExpKind.VCALL) {
            e.kind = ExpKind.VNONRELOC;
            e.info = Lua.GETARG_A(this.code[e.info]);
        } else if (e.kind == ExpKind.VVARARG) {
            this.code[e.info] = LuaC.SETARG_B(this.code[e.info], 2);
            e.kind = ExpKind.VRELOCABLE;
        }
    }

    void dischargeVars(Parser.ExpDesc e) throws CompileException {
        switch (e.kind) {
            case VLOCAL: {
                e.kind = ExpKind.VNONRELOC;
                break;
            }
            case VUPVAL: {
                e.info = this.codeABCAt(4, 0, e.info, 0, e.position);
                e.kind = ExpKind.VRELOCABLE;
                break;
            }
            case VGLOBAL: {
                e.info = this.codeABxAt(5, 0, e.info, e.position);
                e.kind = ExpKind.VRELOCABLE;
                break;
            }
            case VINDEXED: {
                this.freeReg(e.aux);
                this.freeReg(e.info);
                e.info = this.codeABCAt(6, 0, e.info, e.aux, e.position);
                e.kind = ExpKind.VRELOCABLE;
                break;
            }
            case VVARARG: 
            case VCALL: {
                this.setOneRet(e);
                break;
            }
        }
    }

    private int codeLabel(int A, int b, int jump) throws CompileException {
        this.getLabel();
        return this.codeABC(2, A, b, jump);
    }

    private void discharge2Reg(Parser.ExpDesc e, int reg) throws CompileException {
        this.dischargeVars(e);
        switch (e.kind) {
            case VNIL: {
                this.nil(reg, 1);
                break;
            }
            case VFALSE: 
            case VTRUE: {
                this.codeABC(2, reg, e.kind == ExpKind.VTRUE ? 1 : 0, 0);
                break;
            }
            case VK: {
                this.codeABx(1, reg, e.info);
                break;
            }
            case VKNUM: {
                this.codeABx(1, reg, this.numberK(e.nval()));
                break;
            }
            case VRELOCABLE: {
                this.code[e.info] = LuaC.SETARG_A(this.code[e.info], reg);
                break;
            }
            case VNONRELOC: {
                if (reg == e.info) break;
                this.codeABC(0, reg, e.info, 0);
                break;
            }
            default: {
                LuaC._assert(e.kind == ExpKind.VVOID || e.kind == ExpKind.VJMP);
                return;
            }
        }
        e.info = reg;
        e.kind = ExpKind.VNONRELOC;
    }

    private void discharge2AnyReg(Parser.ExpDesc e) throws CompileException {
        if (e.kind != ExpKind.VNONRELOC) {
            this.reserveRegs(1);
            this.discharge2Reg(e, this.freeReg - 1);
        }
    }

    private void exp2reg(Parser.ExpDesc e, int reg) throws CompileException {
        this.discharge2Reg(e, reg);
        if (e.kind == ExpKind.VJMP) {
            this.concat(e.t, e.info);
        }
        if (e.hasjumps()) {
            int p_f = -1;
            int p_t = -1;
            if (this.needValue(e.t.value) || this.needValue(e.f.value)) {
                int fj = e.kind == ExpKind.VJMP ? -1 : this.jump();
                p_f = this.codeLabel(reg, 0, 1);
                p_t = this.codeLabel(reg, 1, 0);
                this.patchToHere(fj);
            }
            int _final = this.getLabel();
            this.patchListAux(e.f.value, _final, reg, p_f);
            this.patchListAux(e.t.value, _final, reg, p_t);
        }
        e.t.value = -1;
        e.f.value = -1;
        e.info = reg;
        e.kind = ExpKind.VNONRELOC;
    }

    void exp2NextReg(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        this.freeExp(e);
        this.reserveRegs(1);
        this.exp2reg(e, this.freeReg - 1);
    }

    int exp2AnyReg(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        if (e.kind == ExpKind.VNONRELOC) {
            if (!e.hasjumps()) {
                return e.info;
            }
            if (e.info >= this.activeVariableCount) {
                this.exp2reg(e, e.info);
                return e.info;
            }
        }
        this.exp2NextReg(e);
        return e.info;
    }

    void exp2Val(Parser.ExpDesc e) throws CompileException {
        if (e.hasjumps()) {
            this.exp2AnyReg(e);
        } else {
            this.dischargeVars(e);
        }
    }

    int exp2RK(Parser.ExpDesc e) throws CompileException {
        this.exp2Val(e);
        switch (e.kind) {
            case VNIL: 
            case VFALSE: 
            case VTRUE: 
            case VKNUM: {
                if (this.constants.size() > 255) break;
                e.info = e.kind == ExpKind.VNIL ? this.nilK() : (e.kind == ExpKind.VKNUM ? this.numberK(e.nval()) : this.boolK(e.kind == ExpKind.VTRUE));
                e.kind = ExpKind.VK;
                return Lua.RKASK(e.info);
            }
            case VK: {
                if (e.info > 255) break;
                return Lua.RKASK(e.info);
            }
        }
        return this.exp2AnyReg(e);
    }

    void storeVar(Parser.ExpDesc var, Parser.ExpDesc ex) throws CompileException {
        switch (var.kind) {
            case VLOCAL: {
                this.freeExp(ex);
                this.exp2reg(ex, var.info);
                return;
            }
            case VUPVAL: {
                int e = this.exp2AnyReg(ex);
                this.codeABCAt(8, e, var.info, 0, var.position);
                break;
            }
            case VGLOBAL: {
                int e = this.exp2AnyReg(ex);
                this.codeABxAt(7, e, var.info, var.position);
                break;
            }
            case VINDEXED: {
                int e = this.exp2RK(ex);
                this.codeABCAt(9, var.info, var.aux, e, var.position);
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
        this.freeExp(ex);
    }

    void self(Parser.ExpDesc e, Parser.ExpDesc key) throws CompileException {
        this.exp2AnyReg(e);
        this.freeExp(e);
        int func = this.freeReg;
        this.reserveRegs(2);
        this.codeABC(11, func, e.info, this.exp2RK(key));
        this.freeExp(key);
        e.info = func;
        e.kind = ExpKind.VNONRELOC;
    }

    private void invertJump(Parser.ExpDesc e) throws CompileException {
        int pc = this.getJumpControl(e.info);
        int op = this.code[pc];
        LuaC._assert(Lua.testTMode(Lua.GET_OPCODE(op)) && Lua.GET_OPCODE(op) != 27 && Lua.GET_OPCODE(op) != 26);
        int a = Lua.GETARG_A(op);
        int nota = a != 0 ? 0 : 1;
        this.code[pc] = LuaC.SETARG_A(op, nota);
    }

    private int jumpOnCond(Parser.ExpDesc e, int cond) throws CompileException {
        int ie;
        if (e.kind == ExpKind.VRELOCABLE && Lua.GET_OPCODE(ie = this.code[e.info]) == 19) {
            --this.pc;
            return this.condJump(26, Lua.GETARG_B(ie), 0, cond != 0 ? 0 : 1, this.lexer.lastPosition());
        }
        this.discharge2AnyReg(e);
        this.freeExp(e);
        return this.condJump(27, 255, e.info, cond, this.lexer.lastPosition());
    }

    void goIfTrue(Parser.ExpDesc e) throws CompileException {
        int pc;
        this.dischargeVars(e);
        switch (e.kind) {
            case VTRUE: 
            case VK: 
            case VKNUM: {
                pc = -1;
                break;
            }
            case VFALSE: {
                pc = this.jump();
                break;
            }
            case VJMP: {
                this.invertJump(e);
                pc = e.info;
                break;
            }
            default: {
                pc = this.jumpOnCond(e, 0);
            }
        }
        this.concat(e.f, pc);
        this.patchToHere(e.t.value);
        e.t.value = -1;
    }

    private void goIfFalse(Parser.ExpDesc e) throws CompileException {
        int pc;
        this.dischargeVars(e);
        switch (e.kind) {
            case VNIL: 
            case VFALSE: {
                pc = -1;
                break;
            }
            case VTRUE: {
                pc = this.jump();
                break;
            }
            case VJMP: {
                pc = e.info;
                break;
            }
            default: {
                pc = this.jumpOnCond(e, 1);
            }
        }
        this.concat(e.t, pc);
        this.patchToHere(e.f.value);
        e.f.value = -1;
    }

    private void codeNot(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        switch (e.kind) {
            case VNIL: 
            case VFALSE: {
                e.kind = ExpKind.VTRUE;
                break;
            }
            case VTRUE: 
            case VK: 
            case VKNUM: {
                e.kind = ExpKind.VFALSE;
                break;
            }
            case VJMP: {
                this.invertJump(e);
                break;
            }
            case VRELOCABLE: 
            case VNONRELOC: {
                this.discharge2AnyReg(e);
                this.freeExp(e);
                e.info = this.codeABC(19, 0, e.info, 0);
                e.kind = ExpKind.VRELOCABLE;
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
        int temp = e.f.value;
        e.f.value = e.t.value;
        e.t.value = temp;
        this.removeValues(e.f.value);
        this.removeValues(e.t.value);
    }

    void indexed(Parser.ExpDesc t, Parser.ExpDesc k, long pos) throws CompileException {
        t.aux = this.exp2RK(k);
        t.kind = ExpKind.VINDEXED;
        t.position = pos;
    }

    private boolean constFolding(int op, Parser.ExpDesc e1, Parser.ExpDesc e2) throws CompileException {
        double r;
        if (!e1.isnumeral() || !e2.isnumeral()) {
            return false;
        }
        double v1 = e1.nval().toDouble();
        double v2 = e2.nval().toDouble();
        switch (op) {
            case 12: {
                r = v1 + v2;
                break;
            }
            case 13: {
                r = v1 - v2;
                break;
            }
            case 14: {
                r = v1 * v2;
                break;
            }
            case 15: {
                if (v2 == 0.0) {
                    return false;
                }
                r = v1 / v2;
                break;
            }
            case 16: {
                if (v2 == 0.0) {
                    return false;
                }
                r = OperationHelper.mod(v1, v2);
                break;
            }
            case 17: {
                r = Math.pow(v1, v2);
                break;
            }
            case 18: {
                r = -v1;
                break;
            }
            case 20: {
                return false;
            }
            default: {
                LuaC._assert(false);
                return false;
            }
        }
        if (Double.isNaN(r)) {
            return false;
        }
        e1.setNval(ValueFactory.valueOf(r));
        return true;
    }

    private void codeArith(int op, Parser.ExpDesc e1, Parser.ExpDesc e2, long position) throws CompileException {
        if (this.constFolding(op, e1, e2)) {
            return;
        }
        int o2 = op != 18 && op != 20 ? this.exp2RK(e2) : 0;
        int o1 = this.exp2RK(e1);
        if (o1 > o2) {
            this.freeExp(e1);
            this.freeExp(e2);
        } else {
            this.freeExp(e2);
            this.freeExp(e1);
        }
        e1.info = this.codeABCAt(op, 0, o1, o2, position);
        e1.kind = ExpKind.VRELOCABLE;
    }

    private void codeComparison(int op, int cond, Parser.ExpDesc e1, Parser.ExpDesc e2, long position) throws CompileException {
        int o1 = this.exp2RK(e1);
        int o2 = this.exp2RK(e2);
        this.freeExp(e2);
        this.freeExp(e1);
        if (cond == 0 && op != 23) {
            int temp = o1;
            o1 = o2;
            o2 = temp;
            cond = 1;
        }
        e1.info = this.condJump(op, cond, o1, o2, position);
        e1.kind = ExpKind.VJMP;
    }

    void prefix(UnOpr op, Parser.ExpDesc e, long position) throws CompileException {
        Parser.ExpDesc e2 = new Parser.ExpDesc();
        e2.init(ExpKind.VKNUM, 0);
        switch (op) {
            case MINUS: {
                if (e.kind == ExpKind.VK) {
                    this.exp2AnyReg(e);
                }
                this.codeArith(18, e, e2, position);
                break;
            }
            case NOT: {
                this.codeNot(e);
                break;
            }
            case LEN: {
                this.exp2AnyReg(e);
                this.codeArith(20, e, e2, position);
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
    }

    void infix(BinOpr op, Parser.ExpDesc v) throws CompileException {
        switch (op) {
            case AND: {
                this.goIfTrue(v);
                break;
            }
            case OR: {
                this.goIfFalse(v);
                break;
            }
            case CONCAT: {
                this.exp2NextReg(v);
                break;
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case POW: {
                if (v.isnumeral()) break;
                this.exp2RK(v);
                break;
            }
            default: {
                this.exp2RK(v);
            }
        }
    }

    void posfix(BinOpr op, Parser.ExpDesc e1, Parser.ExpDesc e2, long position) throws CompileException {
        switch (op) {
            case AND: {
                LuaC._assert(e1.t.value == -1);
                this.dischargeVars(e2);
                this.concat(e2.f, e1.f.value);
                e1.setValue(e2);
                break;
            }
            case OR: {
                LuaC._assert(e1.f.value == -1);
                this.dischargeVars(e2);
                this.concat(e2.t, e1.t.value);
                e1.setValue(e2);
                break;
            }
            case CONCAT: {
                this.exp2Val(e2);
                if (e2.kind == ExpKind.VRELOCABLE && Lua.GET_OPCODE(this.code[e2.info]) == 21) {
                    LuaC._assert(e1.info == Lua.GETARG_B(this.code[e2.info]) - 1);
                    this.freeExp(e1);
                    this.code[e2.info] = LuaC.SETARG_B(this.code[e2.info], e1.info);
                    e1.kind = ExpKind.VRELOCABLE;
                    e1.info = e2.info;
                    break;
                }
                this.exp2NextReg(e2);
                this.codeArith(21, e1, e2, position);
                break;
            }
            case ADD: {
                this.codeArith(12, e1, e2, position);
                break;
            }
            case SUB: {
                this.codeArith(13, e1, e2, position);
                break;
            }
            case MUL: {
                this.codeArith(14, e1, e2, position);
                break;
            }
            case DIV: {
                this.codeArith(15, e1, e2, position);
                break;
            }
            case MOD: {
                this.codeArith(16, e1, e2, position);
                break;
            }
            case POW: {
                this.codeArith(17, e1, e2, position);
                break;
            }
            case EQ: {
                this.codeComparison(23, 1, e1, e2, position);
                break;
            }
            case NE: {
                this.codeComparison(23, 0, e1, e2, position);
                break;
            }
            case LT: {
                this.codeComparison(24, 1, e1, e2, position);
                break;
            }
            case LE: {
                this.codeComparison(25, 1, e1, e2, position);
                break;
            }
            case GT: {
                this.codeComparison(24, 0, e1, e2, position);
                break;
            }
            case GE: {
                this.codeComparison(25, 0, e1, e2, position);
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
    }

    void fixPosition(long position) {
        this.lineInfo[this.pc - 1] = Lex.unpackLine(position);
        this.columnInfo[this.pc - 1] = Lex.unpackColumn(position);
    }

    private int code(int instruction, long position) throws CompileException {
        this.dischargeJumpPc();
        if (this.code == null || this.pc + 1 > this.code.length) {
            this.code = LuaC.realloc(this.code, this.pc * 2 + 1);
        }
        this.code[this.pc] = instruction;
        if (this.lineInfo == null || this.pc + 1 > this.lineInfo.length) {
            this.lineInfo = LuaC.realloc(this.lineInfo, this.pc * 2 + 1);
            this.columnInfo = LuaC.realloc(this.columnInfo, this.pc * 2 + 1);
        }
        this.lineInfo[this.pc] = Lex.unpackLine(position);
        this.columnInfo[this.pc] = Lex.unpackColumn(position);
        return this.pc++;
    }

    int codeABCAt(int o, int a, int b, int c, long position) throws CompileException {
        LuaC._assert(Lua.getOpMode(o) == 0);
        LuaC._assert(Lua.getBMode(o) != 0 || b == 0);
        LuaC._assert(Lua.getCMode(o) != 0 || c == 0);
        LuaC._assert(position > 0L);
        return this.code(LuaC.CREATE_ABC(o, a, b, c), position);
    }

    int codeABC(int o, int a, int b, int c) throws CompileException {
        LuaC._assert(Lua.getOpMode(o) == 0);
        LuaC._assert(Lua.getBMode(o) != 0 || b == 0);
        LuaC._assert(Lua.getCMode(o) != 0 || c == 0);
        return this.code(LuaC.CREATE_ABC(o, a, b, c), this.lexer.lastPosition());
    }

    int codeABxAt(int o, int a, int bc, long position) throws CompileException {
        LuaC._assert(Lua.getOpMode(o) == 1 || Lua.getOpMode(o) == 2);
        LuaC._assert(Lua.getCMode(o) == 0);
        LuaC._assert(position > 0L);
        return this.code(LuaC.CREATE_ABx(o, a, bc), position);
    }

    int codeABx(int o, int a, int bc) throws CompileException {
        return this.codeABxAt(o, a, bc, this.lexer.lastPosition());
    }

    void setList(int base, int nelems, int tostore) throws CompileException {
        int c = (nelems - 1) / 50 + 1;
        int b = tostore == -1 ? 0 : tostore;
        LuaC._assert(tostore != 0);
        if (c <= 511) {
            this.codeABC(34, base, b, c);
        } else {
            this.codeABC(34, base, b, 0);
            this.code(c, this.lexer.lastPosition());
        }
        this.freeReg = base + 1;
    }

    static class BlockCnt {
        BlockCnt previous;
        IntPtr breaklist = new IntPtr();
        short nactvar;
        boolean upval;
        boolean isbreakable;

        BlockCnt() {
        }
    }

    static class UpvalueDesc {
        final LuaString name;
        final ExpKind kind;
        final short info;

        UpvalueDesc(LuaString name, ExpKind kind, short info) {
            this.name = name;
            this.kind = kind;
            this.info = info;
        }
    }
}

