/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class ItemComputerBase
extends BlockItem
implements IComputerItem,
IMedia {
    private final ComputerFamily family;

    public ItemComputerBase(BlockComputerBase<?> block, Item.Properties settings) {
        super(block, settings);
        this.family = block.getFamily();
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag options) {
        int id;
        if ((options.m_7050_() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((Component)Component.m_237110_((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return IComputerItem.super.getLabel(stack);
    }

    @Override
    public final ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.m_41714_((Component)Component.m_237113_((String)label));
        } else {
            stack.m_41787_();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull Level world) {
        int id;
        ComputerFamily family = this.getFamily();
        if (family != ComputerFamily.COMMAND && (id = this.getComputerID(stack)) >= 0) {
            return ComputerCraftAPI.createSaveDirMount(world, "computer/" + id, ComputerCraft.computerSpaceLimit);
        }
        return null;
    }
}

