/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.core.DisplayInfoFTBL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public class KnownServerRegistries {
    public static KnownServerRegistries client;
    public static KnownServerRegistries server;
    public final List<ResourceLocation> dimensions;
    public final Map<ResourceLocation, AdvancementInfo> advancements;

    public KnownServerRegistries(FriendlyByteBuf buffer) {
        int i;
        int s = buffer.m_130242_();
        this.dimensions = new ArrayList<ResourceLocation>(s);
        for (i = 0; i < s; ++i) {
            this.dimensions.add(buffer.m_130281_());
        }
        s = buffer.m_130242_();
        this.advancements = new LinkedHashMap<ResourceLocation, AdvancementInfo>(s);
        for (i = 0; i < s; ++i) {
            AdvancementInfo info = new AdvancementInfo();
            info.id = buffer.m_130281_();
            info.name = buffer.m_130238_();
            info.icon = buffer.m_130267_();
            this.advancements.put(info.id, info);
        }
        FTBLibrary.LOGGER.debug("Received server registries");
    }

    public KnownServerRegistries(MinecraftServer server) {
        this.dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : server.m_129785_()) {
            this.dimensions.add(level.m_46472_().m_135782_());
        }
        this.dimensions.sort(null);
        ArrayList<AdvancementInfo> advancementList = new ArrayList<AdvancementInfo>();
        for (Advancement advancement : server.m_129889_().m_136028_()) {
            if (!(advancement.m_138320_() instanceof DisplayInfoFTBL)) continue;
            AdvancementInfo info = new AdvancementInfo();
            info.id = advancement.m_138327_();
            info.name = advancement.m_138320_().m_14977_();
            info.icon = ((DisplayInfoFTBL)advancement.m_138320_()).getIconStackFTBL();
            advancementList.add(info);
        }
        advancementList.sort(Comparator.comparing(o -> o.id));
        this.advancements = new LinkedHashMap<ResourceLocation, AdvancementInfo>(advancementList.size());
        for (AdvancementInfo info : advancementList) {
            this.advancements.put(info.id, info);
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.dimensions.size());
        for (ResourceLocation id : this.dimensions) {
            buffer.m_130085_(id);
        }
        buffer.m_130130_(this.advancements.size());
        for (AdvancementInfo info : this.advancements.values()) {
            buffer.m_130085_(info.id);
            buffer.m_130083_(info.name);
            buffer.m_130055_(info.icon);
        }
    }

    public static class AdvancementInfo {
        public ResourceLocation id;
        public Component name;
        public ItemStack icon;
    }
}

