/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class ApiUtils {
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOM_SOURCE = RandomSource.m_216343_();

    public static JsonElement jsonSerializeFluidStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluid", Registry.f_122822_.m_7981_((Object)fluidStack.getFluid()).toString());
        jsonObject.addProperty("amount", (Number)fluidStack.getAmount());
        if (fluidStack.hasTag()) {
            jsonObject.addProperty("tag", fluidStack.getTag().toString());
        }
        return jsonObject;
    }

    public static FluidStack jsonDeserializeFluidStack(JsonObject jsonObject) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"fluid")));
        int amount = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"amount");
        FluidStack fluidStack = new FluidStack(fluid, amount);
        if (GsonHelper.m_13900_((JsonObject)jsonObject, (String)"tag")) {
            fluidStack.setTag(JsonUtils.readNBT((JsonObject)jsonObject, (String)"tag"));
        }
        return fluidStack;
    }

    public static Pair<ItemStack, Double> breakStackIntoPreciseIngots(RegistryAccess tags, ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String[] type = TagUtils.getMatchingPrefixAndRemaining(tags, stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return Pair.of((Object)IEApi.getPreferredTagStack(tags, TagUtils.createItemWrapper(IETags.getIngot(type[1]))), (Object)val);
        }
        return null;
    }

    public static double getDim(Vec3 vec, int dim) {
        return dim == 0 ? vec.f_82479_ : (dim == 1 ? vec.f_82480_ : vec.f_82481_);
    }

    public static void knockbackNoSource(LivingEntity entity, double strength, double xRatio, double zRatio) {
        entity.f_19812_ = true;
        Vec3 motionOld = entity.m_20184_();
        Vec3 toAdd = new Vec3(xRatio, 0.0, zRatio).m_82541_().m_82490_(strength);
        entity.m_20334_(motionOld.f_82479_ / 2.0 - toAdd.f_82479_, entity.m_20096_() ? Math.min(0.4, motionOld.f_82480_ / 2.0 + strength) : motionOld.f_82480_, motionOld.f_82481_ / 2.0 - toAdd.f_82481_);
    }

    public static void addFutureServerTask(Level world, Runnable task, boolean forceFuture) {
        LogicalSide side = world.f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER;
        BlockableEventLoop tmp = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(side);
        if (forceFuture) {
            int tick = world.f_46443_ ? 0 : ((MinecraftServer)tmp).m_129921_();
            tmp.m_6937_((Runnable)new TickTask(tick, task));
        } else {
            tmp.m_18689_(task);
        }
    }

    public static void addFutureServerTask(Level world, Runnable task) {
        ApiUtils.addFutureServerTask(world, task, false);
    }
}

