/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerShotRenderer
extends EntityRenderer<ChemthrowerShotEntity> {
    public ChemthrowerShotRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(ChemthrowerShotEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        FluidStack f = entity.getFluid();
        if (f.isEmpty() && (f = entity.getFluidSynced()).isEmpty()) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f - this.f_114476_.f_114358_.m_90590_(), true));
        matrixStackIn.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -this.f_114476_.f_114358_.m_90589_(), true));
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)f.getFluid());
        TextureAtlasSprite sprite = ClientUtils.mc().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(props.getStillTexture(f));
        int colour = props.getTintColor(f);
        float a = (float)(colour >> 24 & 0xFF) / 255.0f;
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        int lightAll = entity.getBrightnessForRender();
        int blockLight = Math.max(LightTexture.m_109883_((int)lightAll), LightTexture.m_109883_((int)packedLightIn));
        int skyLight = Math.max(LightTexture.m_109894_((int)lightAll), LightTexture.m_109894_((int)packedLightIn));
        packedLightIn = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        matrixStackIn.m_85841_(0.25f, 0.25f, 0.25f);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(bufferIn, RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_), matrixStackIn);
        builder.defaultColor(r, g, b, a);
        builder.setNormal(0.0f, 1.0f, 0.0f);
        builder.setLight(packedLightIn);
        builder.setOverlay(OverlayTexture.f_118083_);
        builder.m_5483_(-0.25, -0.25, 0.0).m_7421_(sprite.m_118367_(4.0), sprite.m_118393_(4.0)).m_5752_();
        builder.m_5483_(0.25, -0.25, 0.0).m_7421_(sprite.m_118367_(0.0), sprite.m_118393_(4.0)).m_5752_();
        builder.m_5483_(0.25, 0.25, 0.0).m_7421_(sprite.m_118367_(0.0), sprite.m_118393_(0.0)).m_5752_();
        builder.m_5483_(-0.25, 0.25, 0.0).m_7421_(sprite.m_118367_(4.0), sprite.m_118393_(0.0)).m_5752_();
        matrixStackIn.m_85849_();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull ChemthrowerShotEntity chemthrowerShotEntity) {
        return new ResourceLocation("immersiveengineering:textures/models/bullet.png");
    }
}

