/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import java.util.function.BooleanSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.module.SoulSandstoneModule;

@LoadModule(category=ModuleCategory.BUILDING)
public class MoreBrickTypesModule
extends QuarkModule {
    @Config(flag="blue_nether_bricks", description="This also comes with a utility recipe for Red Nether Bricks")
    public boolean enableBlueNetherBricks = true;
    @Config(flag="sandstone_bricks", description="This also includes Red Sandstone Bricks and Soul Sandstone Bricks")
    public boolean enableSandstoneBricks = true;
    @Config(flag="cobblestone_bricks", description="This also includes Mossy Cobblestone Bricks")
    private static boolean enableCobblestoneBricks = true;
    @Config(flag="blackstone_bricks", description="Requires Cobblestone Bricks to be enabled")
    private static boolean enableBlackstoneBricks = true;
    @Config(flag="dirt_bricks", description="Requires Cobblestone Bricks to be enabled")
    private static boolean enableDirtBricks = true;
    @Config(flag="netherrack_bricks", description="Requires Cobblestone Bricks to be enabled")
    private static boolean enableNetherrackBricks = true;

    @Override
    public void register() {
        this.add("blue_nether", Blocks.f_50197_, () -> this.enableBlueNetherBricks);
        this.add("sandstone", Blocks.f_50062_, () -> this.enableSandstoneBricks);
        this.add("red_sandstone", Blocks.f_50394_, () -> this.enableSandstoneBricks);
        this.add("soul_sandstone", Blocks.f_50062_, () -> this.enableSandstoneBricks && ModuleLoader.INSTANCE.isModuleEnabled(SoulSandstoneModule.class));
        this.add("cobblestone", Blocks.f_50652_, () -> enableCobblestoneBricks);
        this.add("mossy_cobblestone", Blocks.f_50079_, () -> enableCobblestoneBricks);
        this.add("blackstone", Blocks.f_50730_, () -> enableBlackstoneBricks && enableCobblestoneBricks);
        this.add("dirt", Blocks.f_50493_, () -> enableDirtBricks && enableCobblestoneBricks);
        this.add("netherrack", Blocks.f_50134_, () -> enableNetherrackBricks && enableCobblestoneBricks);
    }

    private void add(String name, Block parent, BooleanSupplier cond) {
        VariantHandler.addSlabStairsWall(new QuarkBlock(name + "_bricks", this, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent).m_60999_()).setCondition(cond));
    }
}

