/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.client.handler.TopLayerTooltipHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class MicrocraftingHelperModule
extends QuarkModule {
    @OnlyIn(value=Dist.CLIENT)
    private static Screen currentScreen;
    private static Recipe<?> currentRecipe;
    private static final Stack<StackedRecipe> recipes;
    private static int compoundCount;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClick(ScreenEvent.MouseButtonPressed.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof CraftingScreen) {
            RecipeBookComponent recipeBook;
            Pair<GhostRecipe, GhostRecipe.GhostIngredient> pair;
            CraftingScreen cscreen = (CraftingScreen)screen;
            if (event.getButton() == 1 && (pair = this.getHoveredGhost((AbstractContainerScreen<?>)cscreen, recipeBook = cscreen.m_5564_())) != null) {
                GhostRecipe ghost = (GhostRecipe)pair.getLeft();
                GhostRecipe.GhostIngredient ghostIngr = (GhostRecipe.GhostIngredient)pair.getRight();
                Ingredient ingr = ghostIngr.f_100161_;
                Recipe<?> recipeToSet = this.getRecipeToSet(recipeBook, ingr, true);
                if (recipeToSet == null) {
                    recipeToSet = this.getRecipeToSet(recipeBook, ingr, false);
                }
                if (recipeToSet != null) {
                    int ourCount = 0;
                    ItemStack testStack = recipeToSet.m_8043_();
                    for (int j = 1; j < ghost.m_100158_(); ++j) {
                        GhostRecipe.GhostIngredient testGhostIngr = ghost.m_100141_(j);
                        Ingredient testIngr = testGhostIngr.f_100161_;
                        if (!testIngr.test(testStack)) continue;
                        ++ourCount;
                    }
                    if (ourCount > 0) {
                        int prevCount = compoundCount;
                        int reqCount = ourCount * prevCount;
                        int mult = (int)Math.ceil((double)ourCount / (double)testStack.m_41613_());
                        Recipe ghostRecipe = ghost.m_100159_();
                        StackedRecipe stackedRecipe = new StackedRecipe(ghostRecipe, testStack, compoundCount *= mult, this.getClearCondition(ingr, reqCount));
                        boolean stackIt = true;
                        if (recipes.isEmpty()) {
                            ItemStack rootDisplayStack = ghostRecipe.m_8043_();
                            StackedRecipe rootRecipe = new StackedRecipe(null, rootDisplayStack, rootDisplayStack.m_41613_(), () -> recipes.size() == 1);
                            recipes.add(rootRecipe);
                        } else {
                            for (int i = 0; i < recipes.size(); ++i) {
                                StackedRecipe currRecipe = (StackedRecipe)recipes.get(recipes.size() - i - 1);
                                if (currRecipe.recipe != recipeToSet) continue;
                                for (int j = 0; j <= i; ++j) {
                                    recipes.pop();
                                }
                                stackIt = false;
                                compoundCount = currRecipe.count;
                                break;
                            }
                        }
                        if (stackIt) {
                            recipes.add(stackedRecipe);
                        }
                    }
                    ghost.m_100140_();
                    mc.f_91072_.m_105217_(mc.f_91074_.f_36096_.f_38840_, recipeToSet, true);
                    currentRecipe = recipeToSet;
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onDrawGui(ContainerScreenEvent.Render.Background event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof CraftingScreen) {
            GhostRecipe.GhostIngredient ingr;
            Pair<GhostRecipe, GhostRecipe.GhostIngredient> pair;
            CraftingScreen cscreen = (CraftingScreen)screen;
            PoseStack mstack = event.getPoseStack();
            ItemRenderer render = mc.m_91291_();
            int left = cscreen.getGuiLeft() + 95;
            int top = cscreen.getGuiTop() + 6;
            if (!recipes.isEmpty()) {
                int start;
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
                mstack.m_85836_();
                Screen.m_93143_((PoseStack)mstack, (int)left, (int)top, (int)0, (float)0.0f, (float)108.0f, (int)80, (int)20, (int)256, (int)256);
                mstack.m_85849_();
                for (int i = start = Math.max(0, recipes.size() - 3); i < recipes.size(); ++i) {
                    int index = i - start;
                    StackedRecipe recipe = (StackedRecipe)recipes.get(i);
                    int x = left + index * 24 + 2;
                    int y = top + 2;
                    ItemStack drawStack = recipe.displayItem;
                    render.m_115123_(drawStack, x, y);
                    render.m_115169_(mc.f_91062_, drawStack, x, y);
                    if (index <= 0) continue;
                    mc.f_91062_.m_92883_(mstack, "<", (float)(x - 6), (float)(y + 4), 0x3F3F3F);
                }
            }
            if ((pair = this.getHoveredGhost((AbstractContainerScreen<?>)cscreen, cscreen.m_5564_())) != null && (ingr = (GhostRecipe.GhostIngredient)pair.getRight()) != null) {
                TopLayerTooltipHandler.setTooltip(Lists.newArrayList((Object[])new String[]{I18n.m_118938_((String)"quark.misc.rightclick_to_craft", (Object[])new Object[0])}), event.getMouseX(), event.getMouseY() - 15);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen prevScreen = currentScreen;
        currentScreen = mc.f_91080_;
        boolean clearCompound = true;
        if (prevScreen != currentScreen) {
            recipes.clear();
            currentRecipe = null;
        }
        if (!recipes.isEmpty()) {
            GhostRecipe ghost;
            CraftingScreen crafting;
            RecipeBookComponent book;
            Screen screen = currentScreen;
            if (screen instanceof CraftingScreen && (book = (crafting = (CraftingScreen)screen).m_5564_()) != null && ((ghost = book.f_100269_) == null || currentRecipe != null && ghost.m_100159_() != null && ghost.m_100159_() != currentRecipe)) {
                recipes.clear();
                currentRecipe = null;
            }
            if (!recipes.isEmpty()) {
                StackedRecipe top = recipes.peek();
                if (top.clearCondition.getAsBoolean()) {
                    if (top.recipe != null) {
                        mc.f_91072_.m_105217_(mc.f_91074_.f_36096_.f_38840_, top.recipe, true);
                        currentRecipe = top.recipe;
                        compoundCount = top.count;
                    }
                    recipes.pop();
                }
                clearCompound = false;
            }
        }
        if (clearCompound) {
            compoundCount = 1;
        }
    }

    private Recipe<?> getRecipeToSet(RecipeBookComponent recipeBook, Ingredient ingr, boolean craftableOnly) {
        EditBox text = recipeBook.f_100281_;
        for (ItemStack stack : ingr.m_43908_()) {
            String itemName = stack.m_41786_().m_6881_().getString().toLowerCase(Locale.ROOT).trim();
            text.m_94144_(itemName);
            recipeBook.m_100392_();
            RecipeBookPage page = recipeBook.f_100284_;
            if (page == null) continue;
            ArrayList<RecipeCollection> recipeLists = page.f_100399_;
            if ((recipeLists = new ArrayList<RecipeCollection>(recipeLists)) == null || recipeLists.size() <= 0) continue;
            recipeLists.removeIf(rl -> {
                List list = rl.m_100513_(craftableOnly);
                return list == null || list.isEmpty();
            });
            if (recipeLists.isEmpty()) {
                return null;
            }
            Collections.sort(recipeLists, (rl1, rl2) -> {
                if (rl1 == rl2) {
                    return 0;
                }
                Recipe r1 = (Recipe)rl1.m_100513_(craftableOnly).get(0);
                Recipe r2 = (Recipe)rl2.m_100513_(craftableOnly).get(0);
                return this.compareRecipes(r1, r2);
            });
            for (RecipeCollection list : recipeLists) {
                List recipeList = list.m_100513_(craftableOnly);
                recipeList.sort(this::compareRecipes);
                for (Recipe recipe : recipeList) {
                    if (!ingr.test(recipe.m_8043_())) continue;
                    return recipe;
                }
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int compareRecipes(Recipe<?> r1, Recipe<?> r2) {
        boolean id2Mc;
        if (r1 == r2) {
            return 0;
        }
        String id1 = r1.m_6423_().toString();
        String id2 = r2.m_6423_().toString();
        boolean id1Mc = id1.startsWith("minecraft");
        if (id1Mc != (id2Mc = id2.startsWith("minecraft"))) {
            return id1Mc ? -1 : 1;
        }
        return id1.compareTo(id2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private BooleanSupplier getClearCondition(Ingredient ingr, int req) {
        Minecraft mc = Minecraft.m_91087_();
        return () -> {
            int missing = req;
            for (ItemStack invStack : mc.f_91074_.m_150109_().f_35974_) {
                if (!ingr.test(invStack) || (missing -= invStack.m_41613_()) > 0) continue;
                return true;
            }
            return false;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private Pair<GhostRecipe, GhostRecipe.GhostIngredient> getHoveredGhost(AbstractContainerScreen<?> cscreen, RecipeBookComponent recipeBook) {
        GhostRecipe ghost;
        Slot slot = cscreen.getSlotUnderMouse();
        if (recipeBook != null && slot != null && (ghost = recipeBook.f_100269_) != null && ghost.m_100159_() != null) {
            for (int i = 1; i < ghost.m_100158_(); ++i) {
                GhostRecipe.GhostIngredient ghostIngr = ghost.m_100141_(i);
                if (ghostIngr.m_100169_() != slot.f_40220_ || ghostIngr.m_100170_() != slot.f_40221_) continue;
                return Pair.of((Object)ghost, (Object)ghostIngr);
            }
        }
        return null;
    }

    static {
        recipes = new Stack();
        compoundCount = 1;
    }

    private record StackedRecipe(Recipe<?> recipe, ItemStack displayItem, int count, BooleanSupplier clearCondition) {
        private StackedRecipe(Recipe<?> recipe, ItemStack displayItem, int count, BooleanSupplier clearCondition) {
            this.recipe = recipe;
            this.count = count;
            this.clearCondition = clearCondition;
            this.displayItem = displayItem.m_41777_();
            this.displayItem.m_41764_(count);
        }
    }
}

