/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.ForgeHooks;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;

public class FuelTooltips {
    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(RenderTooltipEvent.GatherComponents event) {
        int count;
        Screen screen;
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && (screen = Minecraft.m_91087_().f_91080_) != null && screen instanceof AbstractFurnaceScreen && (count = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_)) > 0) {
            Font font = Minecraft.m_91087_().f_91062_;
            String time = FuelTooltips.getDisplayString(count);
            event.getTooltipElements().add(Either.right((Object)new FuelComponent(stack, 18 + font.m_92895_(time), count)));
        }
    }

    private static String getDisplayString(int count) {
        float items = (float)count / (float)Math.max(1, ImprovedTooltipsModule.fuelTimeDivisor);
        String time = String.format(items - (float)((int)items) == 0.0f ? "x%.0f" : "x%.1f", Float.valueOf(items));
        return time;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record FuelComponent(ItemStack stack, int width, int count) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@Nonnull Font font, int tooltipX, int tooltipY, @Nonnull PoseStack pose, @Nonnull ItemRenderer itemRenderer, int something) {
            pose.m_85836_();
            pose.m_85837_((double)tooltipX, (double)tooltipY, 500.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)1, (int)1, (float)0.0f, (float)128.0f, (int)13, (int)13, (int)256, (int)256);
            String time = FuelTooltips.getDisplayString(this.count);
            font.m_92750_(pose, time, 16.0f, 5.0f, 16758272);
            pose.m_85849_();
        }

        public int m_142103_() {
            return 18;
        }

        public int m_142069_(@Nonnull Font font) {
            return this.width;
        }
    }
}

