/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftblibrary.config.NameMap;
import java.util.Optional;

public enum ClaimResults implements ClaimResult
{
    OTHER("other"),
    NOT_OWNER("not_owner"),
    NOT_ENOUGH_POWER("not_enough_power"),
    ALREADY_CLAIMED("already_claimed"),
    DIMENSION_FORBIDDEN("dimension_forbidden"),
    NOT_CLAIMED("not_claimed"),
    ALREADY_LOADED("already_loaded"),
    NOT_LOADED("not_loaded");

    public static final NameMap<ClaimResults> NAME_MAP;
    private final String resultName;

    private ClaimResults(String resultName) {
        this.resultName = resultName;
    }

    public static Optional<ClaimResults> forName(String name) {
        return Optional.ofNullable((ClaimResults)NAME_MAP.get(name));
    }

    @Override
    public String claimResultName() {
        return this.resultName;
    }

    static {
        NAME_MAP = NameMap.of((Object)OTHER, (Object[])ClaimResults.values()).create();
    }
}

