/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.api;

import java.util.UUID;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IWaystone {
    public UUID getWaystoneUid();

    public String getName();

    public ResourceKey<Level> getDimension();

    public boolean wasGenerated();

    public boolean isGlobal();

    public boolean isOwner(Player var1);

    public BlockPos getPos();

    public boolean isValid();

    @Nullable
    public UUID getOwnerUid();

    public ResourceLocation getWaystoneType();

    default public boolean hasName() {
        return !this.getName().isEmpty();
    }

    default public boolean hasOwner() {
        return this.getOwnerUid() != null;
    }

    default public boolean isValidInLevel(ServerLevel level) {
        return false;
    }

    default public TeleportDestination resolveDestination(ServerLevel level) {
        return new TeleportDestination(level, Vec3.m_82512_((Vec3i)this.getPos()), Direction.NORTH);
    }
}

