/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.elements;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DerrickTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPClientConfig;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.Heightmap;

public class PipeConfig
extends Button {
    static final Button.OnPress NO_ACTION = b -> {};
    public static final int EMPTY = 0;
    public static final int PIPE_NORMAL = 1;
    public static final int PIPE_PERFORATED = 2;
    public static final int PIPE_PERFORATED_FIXED = 3;
    private final int dynTextureWidth;
    private final int dynTextureHeight;
    private final DynamicTexture gridTexture;
    private final RenderType gridTextureRenderType;
    private final ResourceLocation dynTextureRL;
    private final int pipeNormalColor;
    private final int pipePerforatedColor;
    private final int pipePerforatedFixedColor;
    protected Grid grid;
    protected ColumnPos tilePos;
    protected int gridWidthScaled;
    protected int gridHeightScaled;
    protected int gridScale;
    int[] pipeCountArray = new int[4];

    public PipeConfig(DerrickTileEntity tile, int x, int y, int width, int height, int gridWidth, int gridHeight, int gridScale) {
        super(x, y, width, height, (Component)Component.m_237119_(), NO_ACTION);
        this.tilePos = Utils.toColumnPos(tile.m_58899_());
        this.grid = new Grid(gridWidth, gridHeight);
        this.copyGridFrom(tile.gridStorage);
        this.gridWidthScaled = gridWidth * gridScale;
        this.gridHeightScaled = gridHeight * gridScale;
        this.gridScale = Mth.m_14045_((int)gridScale, (int)1, (int)Integer.MAX_VALUE);
        this.dynTextureWidth = gridWidth;
        this.dynTextureHeight = gridHeight;
        this.gridTexture = new DynamicTexture(this.dynTextureWidth, this.dynTextureHeight, true);
        this.dynTextureRL = ResourceUtils.ip("pipegrid/" + ((Object)((Object)this)).hashCode());
        MCUtil.getTextureManager().m_118495_(this.dynTextureRL, (AbstractTexture)this.gridTexture);
        this.gridTextureRenderType = RenderType.m_110497_((ResourceLocation)this.dynTextureRL);
        this.pipeNormalColor = Integer.valueOf((String)IPClientConfig.GRID_COLORS.pipe_normal_color.get(), 16);
        this.pipePerforatedColor = Integer.valueOf((String)IPClientConfig.GRID_COLORS.pipe_perforated_color.get(), 16);
        this.pipePerforatedFixedColor = Integer.valueOf((String)IPClientConfig.GRID_COLORS.pipe_perforated_fixed_color.get(), 16);
        this.updateTexture();
    }

    public void reset(DerrickTileEntity tile) {
        this.copyGridFrom(tile.gridStorage);
        this.updateTexture();
    }

    private void copyGridFrom(Grid grid) {
        if (grid != null && grid.width == this.grid.width && grid.height == this.grid.height) {
            System.arraycopy(grid.array, 0, this.grid.array, 0, this.grid.array.length);
            this.grid.changed = true;
        }
    }

    public Grid getGrid() {
        return this.grid;
    }

    public int getGridScale() {
        return this.gridScale;
    }

    public void dispose() {
        this.gridTexture.close();
        MCUtil.getTextureManager().m_118513_(this.dynTextureRL);
    }

    public void updateTexture() {
        NativeImage image = this.gridTexture.m_117991_();
        int texCenterX = this.grid.width / this.gridScale;
        int texCenterY = this.grid.height / this.gridScale;
        int x2 = this.grid.width / 2;
        int y2 = this.grid.height / 2;
        int x4 = this.grid.width / 4;
        int y4 = this.grid.height / 4;
        ClientLevel world = MCUtil.getLevel();
        int a = 0;
        for (int gy = 0; gy < this.grid.getHeight(); ++gy) {
            int gx = 0;
            while (gx < this.grid.getWidth()) {
                int color = switch (this.grid.get(gx, gy)) {
                    case 0 -> {
                        int tmp = 0;
                        if (gx < texCenterX - 2 || gx > texCenterX + 2 || gy < texCenterY - 2 || gy > texCenterY + 2) {
                            float f;
                            int px = gx - x2;
                            int py = gy - y2;
                            ColumnPos c = new ColumnPos(this.tilePos.f_140723_() + px, this.tilePos.f_140724_() + py);
                            int y = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(c.f_140723_(), 0, c.f_140724_())).m_123342_() - 1;
                            BlockPos p = new BlockPos(c.f_140723_(), y, c.f_140724_());
                            float v0 = f = a % 2 == 0 ? 0.55f : 0.6f;
                            if (gx % x4 == 0 || gy % y4 == 0) {
                                f -= 0.15f;
                            }
                            tmp = world.m_8055_((BlockPos)p).m_60780_((BlockGetter)world, (BlockPos)p).f_76396_;
                            int r = (int)((float)(tmp >> 16 & 0xFF) * f);
                            int g = (int)((float)(tmp >> 8 & 0xFF) * f);
                            int b = (int)((float)(tmp >> 0 & 0xFF) * f);
                            tmp = r << 16 | g << 8 | b;
                        }
                        yield tmp;
                    }
                    case 1 -> this.pipeNormalColor;
                    case 2 -> this.pipePerforatedColor;
                    case 3 -> this.pipePerforatedFixedColor;
                    default -> 0;
                };
                image.m_84988_(gx, gy, PipeConfig.toABGR(color));
                ++gx;
                ++a;
            }
        }
        this.gridTexture.m_117985_();
    }

    public void m_6305_(PoseStack matrix, int mx, int my, float partialTicks) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer builder = buffer.m_6299_(this.gridTextureRenderType);
        matrix.m_85836_();
        matrix.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        Matrix4f mat = matrix.m_85850_().m_85861_();
        int x = this.grid.width * this.gridScale;
        int y = this.grid.height * this.gridScale;
        builder.m_85982_(mat, 0.0f, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(mat, (float)x, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(mat, (float)x, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        matrix.m_85849_();
        buffer.m_109911_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.m_7972_(button) && (flag = this.m_93680_(mouseX, mouseY))) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.onGridClick((int)(mouseX - (double)this.f_93620_) / this.gridScale, (int)(mouseY - (double)this.f_93621_) / this.gridScale, button);
            return true;
        }
        return false;
    }

    protected void onGridClick(int x, int y, int button) {
        int type = this.grid.get(x, y);
        if ((type == 1 || type == 2) && type != 3) {
            int[] array = this.getPipeCount();
            if (type == 1 && array[2] < 2) {
                this.grid.set(x, y, 2);
            } else {
                this.grid.set(x, y, 1);
            }
        } else {
            this.grid.clearGrid();
            this.grid.drawLine(this.grid.getWidth() / 2, this.grid.getHeight() / 2, x, y, 1);
            this.grid.set(this.grid.getWidth() / 2, this.grid.getHeight() / 2, 3);
            this.grid.set(Mth.m_14045_((int)x, (int)0, (int)(this.grid.getWidth() - 1)), Mth.m_14045_((int)y, (int)0, (int)(this.grid.getHeight() - 1)), 3);
        }
        this.updateTexture();
    }

    private int[] getPipeCount() {
        if (this.grid.changed) {
            this.pipeCountArray = new int[4];
            for (int i = 0; i < this.grid.size(); ++i) {
                int type;
                int n = type = this.grid.get(i);
                this.pipeCountArray[n] = this.pipeCountArray[n] + 1;
            }
            this.grid.changed = false;
        }
        return this.pipeCountArray;
    }

    protected boolean m_7972_(int button) {
        return button == 0;
    }

    public PipeConfig copyDataFrom(PipeConfig other) {
        if (other != null) {
            this.gridScale = other.gridScale;
            this.grid = other.grid;
            this.updateTexture();
        }
        return this;
    }

    private static int toABGR(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0xFF000000 | b << 16 | g << 8 | r;
    }

    public static class Grid {
        private boolean changed;
        private int width;
        private int height;
        private byte[] array;

        public Grid(int width, int height) {
            this.width = width;
            this.height = height;
            this.array = new byte[width * height];
        }

        Grid() {
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int size() {
            return this.array.length;
        }

        public void set(int x, int y, int value) {
            this.set(this.index(x, y), value);
        }

        public void set(int index, int value) {
            if (index >= 0 && index < this.array.length && this.array[index] != value) {
                this.array[index] = (byte)(value & 0xFF);
                this.changed = true;
            }
        }

        public int get(int x, int y) {
            return this.get(this.index(x, y));
        }

        public int get(int index) {
            if (index >= 0 && index < this.array.length) {
                return this.array[index] & 0xFF;
            }
            return 0;
        }

        public void clearGrid() {
            for (int i = 0; i < this.size(); ++i) {
                this.array[i] = 0;
            }
        }

        public void drawLine(int xa, int ya, int xb, int yb, int value) {
            xa = Mth.m_14045_((int)xa, (int)0, (int)(this.width - 1));
            xb = Mth.m_14045_((int)xb, (int)0, (int)(this.width - 1));
            ya = Mth.m_14045_((int)ya, (int)0, (int)(this.height - 1));
            yb = Mth.m_14045_((int)yb, (int)0, (int)(this.height - 1));
            int dx = xb - xa;
            int dy = yb - ya;
            int length = Math.max(Math.abs(dx), Math.abs(dy));
            float tx = (float)dx / (float)length;
            float ty = (float)dy / (float)length;
            float x = xa;
            float y = ya;
            int lx = -1;
            int ly = -1;
            for (int i = 1; i <= length; ++i) {
                int cx = Math.round(x);
                int cy = Math.round(y);
                if (lx != cx || ly != cy) {
                    this.set(cx, cy, value);
                    lx = cx;
                    ly = cy;
                }
                x += tx;
                y += ty;
            }
        }

        int index(int x, int y) {
            return this.width * y + x;
        }

        public CompoundTag toCompound() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("width", this.width);
            nbt.m_128405_("height", this.height);
            nbt.m_128382_("grid", this.array);
            return nbt;
        }

        public static Grid fromCompound(CompoundTag nbt) {
            Grid grid = new Grid();
            grid.width = nbt.m_128451_("width");
            grid.height = nbt.m_128451_("height");
            grid.array = nbt.m_128463_("grid");
            if (grid.array.length != grid.width * grid.height) {
                throw new IllegalStateException("Grid width and height don't match array.");
            }
            return grid;
        }
    }
}

