/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnegative;
import net.minecraft.client.renderer.Rect2i;

public class ImmutableRect2i {
    public static final ImmutableRect2i EMPTY = new ImmutableRect2i(0, 0, 0, 0);
    @Nonnegative
    private final int x;
    @Nonnegative
    private final int y;
    @Nonnegative
    private final int width;
    @Nonnegative
    private final int height;

    public ImmutableRect2i(Rect2i rect) {
        this(rect.m_110085_(), rect.m_110086_(), rect.m_110090_(), rect.m_110091_());
    }

    public ImmutableRect2i(int x, int y, int width, int height) {
        if (x < 0) {
            width -= x;
            x = 0;
        }
        if (y < 0) {
            height -= y;
            y = 0;
        }
        this.x = x;
        this.y = y;
        this.width = Math.max(0, width);
        this.height = Math.max(0, height);
    }

    @Nonnegative
    public int getX() {
        return this.x;
    }

    @Nonnegative
    public int getY() {
        return this.y;
    }

    @Nonnegative
    public int getWidth() {
        return this.width;
    }

    @Nonnegative
    public int getHeight() {
        return this.height;
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public boolean contains(double x, double y) {
        return x >= (double)this.x && y >= (double)this.y && x < (double)(this.x + this.width) && y < (double)(this.y + this.height);
    }

    public boolean intersects(ImmutableRect2i rect) {
        if (this.isEmpty() || rect.isEmpty()) {
            return false;
        }
        return rect.getX() + rect.getWidth() > this.x && rect.getY() + rect.getHeight() > this.y && rect.getX() < this.x + this.width && rect.getY() < this.y + this.height;
    }

    public ImmutableRect2i moveRight(@Nonnegative int x) {
        if (x == 0) {
            return this;
        }
        return new ImmutableRect2i(this.x + x, this.y, this.width, this.height);
    }

    public ImmutableRect2i moveLeft(@Nonnegative int x) {
        if (x == 0) {
            return this;
        }
        return new ImmutableRect2i(this.x - x, this.y, this.width, this.height);
    }

    public ImmutableRect2i moveDown(@Nonnegative int y) {
        if (y == 0) {
            return this;
        }
        return new ImmutableRect2i(this.x, this.y + y, this.width, this.height);
    }

    public ImmutableRect2i moveUp(@Nonnegative int y) {
        if (y == 0) {
            return this;
        }
        return new ImmutableRect2i(this.x, this.y - y, this.width, this.height);
    }

    public ImmutableRect2i insetBy(@Nonnegative int amount) {
        if (amount == 0) {
            return this;
        }
        return new ImmutableRect2i(this.x + amount, this.y + amount, this.width - amount * 2, this.height - amount * 2);
    }

    public ImmutableRect2i expandBy(@Nonnegative int amount) {
        if (amount == 0) {
            return this;
        }
        return new ImmutableRect2i(this.x - amount, this.y - amount, this.width + amount * 2, this.height + amount * 2);
    }

    public ImmutableRect2i cropRight(@Nonnegative int amount) {
        if (amount == 0) {
            return this;
        }
        if (amount > this.width) {
            amount = this.width;
        }
        return new ImmutableRect2i(this.x, this.y, this.width - amount, this.height);
    }

    public ImmutableRect2i cropLeft(@Nonnegative int amount) {
        if (amount == 0) {
            return this;
        }
        if (amount > this.width) {
            amount = this.width;
        }
        return new ImmutableRect2i(this.x + amount, this.y, this.width - amount, this.height);
    }

    public ImmutableRect2i cropBottom(@Nonnegative int amount) {
        if (amount == 0) {
            return this;
        }
        if (amount > this.height) {
            amount = this.height;
        }
        return new ImmutableRect2i(this.x, this.y, this.width, this.height - amount);
    }

    public ImmutableRect2i cropTop(@Nonnegative int amount) {
        if (amount == 0) {
            return this;
        }
        if (amount > this.height) {
            amount = this.height;
        }
        return new ImmutableRect2i(this.x, this.y + amount, this.width, this.height - amount);
    }

    public ImmutableRect2i keepTop(@Nonnegative int amount) {
        if (amount == this.height) {
            return this;
        }
        if (amount > this.height) {
            amount = this.height;
        }
        return new ImmutableRect2i(this.x, this.y, this.width, amount);
    }

    public ImmutableRect2i keepBottom(@Nonnegative int amount) {
        if (amount == this.height) {
            return this;
        }
        if (amount > this.height) {
            amount = this.height;
        }
        int cropAmount = this.height - amount;
        return new ImmutableRect2i(this.x, this.y + cropAmount, this.width, amount);
    }

    public ImmutableRect2i keepRight(@Nonnegative int amount) {
        if (amount == this.width) {
            return this;
        }
        if (amount > this.width) {
            amount = this.width;
        }
        int cropAmount = this.width - amount;
        return new ImmutableRect2i(this.x + cropAmount, this.y, amount, this.height);
    }

    public ImmutableRect2i keepLeft(@Nonnegative int amount) {
        if (amount == this.width) {
            return this;
        }
        if (amount > this.width) {
            amount = this.width;
        }
        return new ImmutableRect2i(this.x, this.y, amount, this.height);
    }

    public ImmutableRect2i addOffset(@Nonnegative int x, @Nonnegative int y) {
        return new ImmutableRect2i(this.x + x, this.y + y, this.width, this.height);
    }

    public ImmutableRect2i matchWidthAndX(ImmutableRect2i rect) {
        return new ImmutableRect2i(rect.getX(), this.y, rect.getWidth(), this.height);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableRect2i) {
            ImmutableRect2i other = (ImmutableRect2i)obj;
            return this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.x;
        hash = hash * 31 + this.y;
        hash = hash * 31 + this.width;
        hash = hash * 31 + this.height;
        return hash;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("width", this.width).add("height", this.height).toString();
    }

    public Rect2i toMutable() {
        return new Rect2i(this.x, this.y, this.width, this.height);
    }
}

