/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.crafting.CategoryRecipeValidator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;

public final class VanillaRecipes {
    private final RecipeManager recipeManager;
    private final IIngredientManager ingredientManager;

    public VanillaRecipes(IIngredientManager ingredientManager) {
        Minecraft minecraft = Minecraft.m_91087_();
        ErrorUtil.checkNotNull(minecraft, "minecraft");
        ClientLevel world = minecraft.f_91073_;
        ErrorUtil.checkNotNull(world, "minecraft world");
        this.recipeManager = world.m_7465_();
        this.ingredientManager = ingredientManager;
    }

    public Map<Boolean, List<CraftingRecipe>> getCraftingRecipes(IRecipeCategory<CraftingRecipe> craftingCategory) {
        CategoryRecipeValidator<CraftingRecipe> validator = new CategoryRecipeValidator<CraftingRecipe>(craftingCategory, this.ingredientManager, 9);
        return this.recipeManager.m_44013_(RecipeType.f_44107_).stream().filter(validator::isRecipeValid).collect(Collectors.partitioningBy(validator::isRecipeHandled));
    }

    public List<StonecutterRecipe> getStonecuttingRecipes(IRecipeCategory<StonecutterRecipe> stonecuttingCategory) {
        CategoryRecipeValidator<StonecutterRecipe> validator = new CategoryRecipeValidator<StonecutterRecipe>(stonecuttingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.f_44112_, validator);
    }

    public List<SmeltingRecipe> getFurnaceRecipes(IRecipeCategory<SmeltingRecipe> furnaceCategory) {
        CategoryRecipeValidator<SmeltingRecipe> validator = new CategoryRecipeValidator<SmeltingRecipe>(furnaceCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.f_44108_, validator);
    }

    public List<SmokingRecipe> getSmokingRecipes(IRecipeCategory<SmokingRecipe> smokingCategory) {
        CategoryRecipeValidator<SmokingRecipe> validator = new CategoryRecipeValidator<SmokingRecipe>(smokingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.f_44110_, validator);
    }

    public List<BlastingRecipe> getBlastingRecipes(IRecipeCategory<BlastingRecipe> blastingCategory) {
        CategoryRecipeValidator<BlastingRecipe> validator = new CategoryRecipeValidator<BlastingRecipe>(blastingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.f_44109_, validator);
    }

    public List<CampfireCookingRecipe> getCampfireCookingRecipes(IRecipeCategory<CampfireCookingRecipe> campfireCategory) {
        CategoryRecipeValidator<CampfireCookingRecipe> validator = new CategoryRecipeValidator<CampfireCookingRecipe>(campfireCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.f_44111_, validator);
    }

    public List<UpgradeRecipe> getSmithingRecipes(IRecipeCategory<UpgradeRecipe> smithingCategory) {
        CategoryRecipeValidator<UpgradeRecipe> validator = new CategoryRecipeValidator<UpgradeRecipe>(smithingCategory, this.ingredientManager, 0);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.f_44113_, validator);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> getValidHandledRecipes(RecipeManager recipeManager, RecipeType<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.m_44013_(recipeType).stream().filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r)).toList();
    }
}

