/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DivingBoardBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<DivingBoardPart> PART = EnumProperty.m_61587_((String)"part", DivingBoardPart.class);
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public DivingBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(PART, (Comparable)((Object)DivingBoardPart.BASE))).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            VoxelShape[] BOARD = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)6.0, (double)16.0), Direction.SOUTH));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BOARD[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
            if (state1.m_61143_(PART) == DivingBoardPart.BASE) {
                VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)4.0, (double)15.0), Direction.SOUTH));
                shapes.add(BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
            }
            return VoxelShapeHelper.combineAll(shapes);
        });
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(state);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
        DivingBoardPart part = (DivingBoardPart)((Object)state.m_61143_(PART));
        BlockPos otherPos = part == DivingBoardPart.BASE ? pos.m_121945_(direction) : pos.m_121945_(direction.m_122424_());
        BlockState otherBlockState = level.m_8055_(otherPos);
        if (otherBlockState.m_60734_() == this && otherBlockState.m_61143_(PART) != part) {
            level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, otherPos, Block.m_49956_((BlockState)otherBlockState));
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_121945_(placer.m_6350_()), (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)DivingBoardPart.BOARD))).m_61124_((Property)DIRECTION, (Comparable)placer.m_6350_()), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)DIRECTION))).m_60795_();
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (level.m_8055_(pos).m_61143_(PART) != DivingBoardPart.BOARD) {
            return;
        }
        if (entityIn instanceof LivingEntity) {
            float strength = 5.0f;
            float maxHeight = 8.0f;
            float height = entityIn.f_19789_ * strength;
            if (height > 0.0f && !entityIn.m_6144_()) {
                if (height > maxHeight - 0.25f) {
                    height = maxHeight - 0.25f;
                }
                entityIn.m_20256_(entityIn.m_20184_().m_82542_(1.0, 0.0, 1.0));
                entityIn.m_5997_(0.0, Math.sqrt(0.22 * (double)(height + 0.25f)), 0.0);
                if (level.f_46443_) {
                    for (int i = 0; i < 5; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, entityIn.f_19854_, entityIn.f_19855_, entityIn.f_19856_, 1.0, 1.0, 1.0);
                    }
                } else {
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_DIVING_BOARD_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 1.0f);
                }
            }
            entityIn.f_19789_ = 0.0f;
        }
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PART});
    }

    public static enum DivingBoardPart implements StringRepresentable
    {
        BASE,
        BOARD;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this == BASE ? "base" : "board";
        }
    }
}

