/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.mojang.datafixers.util.Pair;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

class LootTableGenerator
extends LootTableProvider {
    LootTableGenerator(DataGenerator generator) {
        super(generator);
    }

    @Nonnull
    public List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return List.of(Pair.of(() -> LootTableGenerator::registerBlocks, (Object)LootContextParamSets.f_81421_), Pair.of(() -> LootTableGenerator::registerGeneric, (Object)LootContextParamSets.f_81420_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
        map.forEach((id, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)id, (LootTable)table));
    }

    private static void registerBlocks(BiConsumer<ResourceLocation, LootTable.Builder> add) {
        LootTableGenerator.namedBlockDrop(add, Registry.ModBlocks.DISK_DRIVE);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.MONITOR_NORMAL);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.MONITOR_ADVANCED);
        LootTableGenerator.namedBlockDrop(add, Registry.ModBlocks.PRINTER);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.SPEAKER);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.WIRED_MODEM_FULL);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.WIRELESS_MODEM_NORMAL);
        LootTableGenerator.selfDrop(add, Registry.ModBlocks.WIRELESS_MODEM_ADVANCED);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.COMPUTER_NORMAL);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.COMPUTER_ADVANCED);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.COMPUTER_COMMAND);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.TURTLE_NORMAL);
        LootTableGenerator.computerDrop(add, Registry.ModBlocks.TURTLE_ADVANCED);
        add.accept(((BlockCable)((Object)Registry.ModBlocks.CABLE.get())).m_60589_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Registry.ModItems.CABLE.get()))).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)Registry.ModBlocks.CABLE.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockCable.CABLE, true)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Registry.ModItems.WIRED_MODEM.get()))).m_79080_(ExplosionCondition.m_81661_()).m_79080_(LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)Registry.ModBlocks.CABLE.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.None))).m_81807_())));
    }

    private static void registerGeneric(BiConsumer<ResourceLocation, LootTable.Builder> add) {
        add.accept(CommonHooks.LOOT_TREASURE_DISK, LootTable.m_79147_());
    }

    private static void selfDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> wrapper) {
        LootTableGenerator.blockDrop(add, wrapper, LootItem.m_79579_((ItemLike)((ItemLike)wrapper.get())), ExplosionCondition.m_81661_());
    }

    private static void namedBlockDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> wrapper) {
        LootTableGenerator.blockDrop(add, wrapper, LootItem.m_79579_((ItemLike)((ItemLike)wrapper.get())).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)), ExplosionCondition.m_81661_());
    }

    private static void computerDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> block) {
        LootTableGenerator.blockDrop(add, block, DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("computercraft", "computer")), (LootItemCondition.Builder)AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{BlockNamedEntityLootCondition.BUILDER, HasComputerIdLootCondition.BUILDER, PlayerCreativeLootCondition.BUILDER.m_81807_()}));
    }

    private static void blockDrop(BiConsumer<ResourceLocation, LootTable.Builder> add, Supplier<? extends Block> wrapper, LootPoolEntryContainer.Builder<?> drop, LootItemCondition.Builder condition) {
        Block block = wrapper.get();
        add.accept(block.m_60589_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(drop).m_79080_(condition)));
    }
}

